/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.List;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.commitbarriers.CommitBarrier;
import org.multiverse.commitbarriers.CommitBarrierOpenException;

public final class CountDownCommitBarrier
extends CommitBarrier {
    private volatile int parties;

    public CountDownCommitBarrier(int parties) {
        this(parties, false);
    }

    public CountDownCommitBarrier(int parties, boolean fair) {
        super(parties == 0 ? CommitBarrier.Status.Committed : CommitBarrier.Status.Closed, fair);
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
    }

    public int getParties() {
        return this.parties;
    }

    @Override
    protected boolean isLastParty() {
        return this.getNumberWaiting() == this.parties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void countDown() {
        onCommitTasks = null;
        this.lock.lock();
        try {
            switch (1.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.getStatus().ordinal()]) {
                case 1: {
                    this.addJoiner();
                    if (this.isLastParty()) {
                        onCommitTasks = this.signalCommit();
                        ** break;
                    }
lbl10:
                    // 3 sources

                    break;
                }
                case 2: {
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 3: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        CountDownCommitBarrier.executeTasks(onCommitTasks);
    }

    public void atomicIncParties() {
        this.atomicIncParties(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void atomicIncParties(int extra) {
        if (extra < 0) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case Closed: {
                    if (extra == 0) {
                        return;
                    }
                    this.parties += extra;
                    return;
                }
                case Aborted: {
                    String abortMsg = "Can't call countDown on already aborted CountDownCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                case Committed: {
                    String commitMsg = "Can't call countDown on already committed CountDownCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void incParties(Transaction tx, int extra) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (extra < 0) {
            throw new IllegalArgumentException();
        }
        if (!tx.getStatus().isAlive()) {
            String msg = String.format("[%s] Can't call incParties on dead transaction because it is %s", new Object[]{tx.getConfiguration().getFamilyName(), tx.getStatus()});
            throw new DeadTransactionException(msg);
        }
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case Closed: {
                    if (extra == 0) {
                        return;
                    }
                    this.parties += extra;
                    tx.register(new RestorePartiesCompensatingTask(extra));
                    return;
                }
                case Aborted: {
                    String abortMsg = String.format("[%s] Can't call incParties on already aborted CountDownCommitBarrier", tx.getConfiguration().getFamilyName());
                    throw new CommitBarrierOpenException(abortMsg);
                }
                case Committed: {
                    String commitMsg = String.format("[%s] Can't call incParties on already committed CountDownCommitBarrier", tx.getConfiguration().getFamilyName());
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class RestorePartiesCompensatingTask
    implements TransactionLifecycleListener {
        private final int extra;

        RestorePartiesCompensatingTask(int extra) {
            this.extra = extra;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Transaction tx, TransactionLifecycleEvent event) {
            if (event != TransactionLifecycleEvent.PostAbort) {
                return;
            }
            List<Runnable> onCommitTasks = null;
            CountDownCommitBarrier.this.lock.lock();
            try {
                if (CountDownCommitBarrier.this.getStatus() == CommitBarrier.Status.Closed) {
                    CountDownCommitBarrier.this.parties -= this.extra;
                    if (CountDownCommitBarrier.this.isLastParty()) {
                        onCommitTasks = CountDownCommitBarrier.this.signalCommit();
                    }
                }
            }
            finally {
                CountDownCommitBarrier.this.lock.unlock();
            }
            CommitBarrier.executeTasks(onCommitTasks);
        }
    }
}

