/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.sensors;

import java.util.concurrent.ConcurrentHashMap;
import org.junit.Test;
import org.multiverse.api.TransactionConfiguration;
import org.multiverse.sensors.Profiler;
import org.multiverse.sensors.TransactionSensor;

public class SimpleProfiler
implements Profiler {
    private final ConcurrentHashMap<TransactionConfiguration, TransactionSensor> sensorMap = new ConcurrentHashMap();
    private final PrintThread printThread = new PrintThread();

    @Override
    public TransactionSensor getTransactionSensor(TransactionConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        TransactionSensor sensor = this.sensorMap.get(configuration);
        if (sensor == null) {
            TransactionSensor newCounter = new TransactionSensor(configuration);
            TransactionSensor existingCounter = this.sensorMap.putIfAbsent(configuration, newCounter);
            sensor = existingCounter != null ? existingCounter : newCounter;
        }
        return sensor;
    }

    @Test
    public void startPrintingDaemon() {
        this.printThread.start();
    }

    class PrintThread
    extends Thread {
        public PrintThread() {
            super("PrintThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                System.out.println("------------------ Profiling ----------------------------");
                for (TransactionSensor sensor : SimpleProfiler.this.sensorMap.values()) {
                    System.out.println(sensor);
                }
                try {
                    PrintThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

