/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta;

import java.util.ArrayList;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactionalobjects.CallableNode;

public final class BetaObjectPool {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm,beta.BetaObjectPool.enabled", "true"));
    private static final boolean TRANLOCAL_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.tranlocalPooling", "" + ENABLED));
    private static final boolean TRANLOCALARRAY_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.tranlocalArrayPooling", "" + ENABLED));
    private static final boolean LATCH_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.latchPooling", "" + ENABLED));
    private static final boolean LISTENER_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.listenersPooling", "" + ENABLED));
    private static final boolean LISTENERSARRAY_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.listenersArrayPooling", "" + ENABLED));
    private static final boolean ARRAYLIST_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.arrayListPooling", "" + ENABLED));
    private static final boolean CALLABLENODE_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.beta.BetaObjectPool.callableNodePooling", "" + ENABLED));
    private final boolean tranlocalPoolingEnabled;
    private final boolean tranlocalArrayPoolingEnabled;
    private final boolean latchPoolingEnabled;
    private final boolean listenersPoolingEnabled;
    private final boolean listenersArrayPoolingEnabled;
    private final boolean arrayListPoolingEnabled;
    private final boolean callableNodePoolingEnabled;
    private final BetaRefTranlocal[] tranlocalsBetaRef = new BetaRefTranlocal[100];
    private int lastUsedBetaRef = -1;
    private final BetaIntRefTranlocal[] tranlocalsBetaIntRef = new BetaIntRefTranlocal[100];
    private int lastUsedBetaIntRef = -1;
    private final BetaBooleanRefTranlocal[] tranlocalsBetaBooleanRef = new BetaBooleanRefTranlocal[100];
    private int lastUsedBetaBooleanRef = -1;
    private final BetaDoubleRefTranlocal[] tranlocalsBetaDoubleRef = new BetaDoubleRefTranlocal[100];
    private int lastUsedBetaDoubleRef = -1;
    private final BetaLongRefTranlocal[] tranlocalsBetaLongRef = new BetaLongRefTranlocal[100];
    private int lastUsedBetaLongRef = -1;
    private TranlocalPool[] pools = new TranlocalPool[100];
    private DefaultRetryLatch[] defaultRetryLatchPool = new DefaultRetryLatch[10];
    private int defaultRetryLatchPoolIndex = -1;
    private Listeners[] listenersPool = new Listeners[100];
    private int listenersPoolIndex = -1;
    private ArrayList[] arrayListPool = new ArrayList[10];
    private int arrayListPoolIndex = -1;
    private CallableNode[] callableNodePool = new CallableNode[10];
    private int callableNodePoolIndex = -1;
    private BetaTranlocal[][] tranlocalArrayPool = new BetaTranlocal[8193][];
    private Listeners[] listenersArray = new Listeners[100000];

    public BetaObjectPool() {
        this.arrayListPoolingEnabled = ARRAYLIST_POOLING_ENABLED;
        this.tranlocalArrayPoolingEnabled = TRANLOCALARRAY_POOLING_ENABLED;
        this.tranlocalPoolingEnabled = TRANLOCAL_POOLING_ENABLED;
        this.latchPoolingEnabled = LATCH_POOLING_ENABLED;
        this.listenersPoolingEnabled = LISTENER_POOLING_ENABLED;
        this.listenersArrayPoolingEnabled = LISTENERSARRAY_POOLING_ENABLED;
        this.callableNodePoolingEnabled = CALLABLENODE_POOLING_ENABLED;
    }

    public BetaRefTranlocal take(BetaRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedBetaRef == -1) {
            return new BetaRefTranlocal(owner);
        }
        BetaRefTranlocal tranlocal = this.tranlocalsBetaRef[this.lastUsedBetaRef];
        tranlocal.owner = owner;
        this.tranlocalsBetaRef[this.lastUsedBetaRef] = null;
        --this.lastUsedBetaRef;
        return tranlocal;
    }

    public void put(BetaRefTranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedBetaRef == this.tranlocalsBetaRef.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++this.lastUsedBetaRef;
        this.tranlocalsBetaRef[this.lastUsedBetaRef] = tranlocal;
    }

    public BetaIntRefTranlocal take(BetaIntRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedBetaIntRef == -1) {
            return new BetaIntRefTranlocal(owner);
        }
        BetaIntRefTranlocal tranlocal = this.tranlocalsBetaIntRef[this.lastUsedBetaIntRef];
        tranlocal.owner = owner;
        this.tranlocalsBetaIntRef[this.lastUsedBetaIntRef] = null;
        --this.lastUsedBetaIntRef;
        return tranlocal;
    }

    public void put(BetaIntRefTranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedBetaIntRef == this.tranlocalsBetaIntRef.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++this.lastUsedBetaIntRef;
        this.tranlocalsBetaIntRef[this.lastUsedBetaIntRef] = tranlocal;
    }

    public BetaBooleanRefTranlocal take(BetaBooleanRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedBetaBooleanRef == -1) {
            return new BetaBooleanRefTranlocal(owner);
        }
        BetaBooleanRefTranlocal tranlocal = this.tranlocalsBetaBooleanRef[this.lastUsedBetaBooleanRef];
        tranlocal.owner = owner;
        this.tranlocalsBetaBooleanRef[this.lastUsedBetaBooleanRef] = null;
        --this.lastUsedBetaBooleanRef;
        return tranlocal;
    }

    public void put(BetaBooleanRefTranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedBetaBooleanRef == this.tranlocalsBetaBooleanRef.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++this.lastUsedBetaBooleanRef;
        this.tranlocalsBetaBooleanRef[this.lastUsedBetaBooleanRef] = tranlocal;
    }

    public BetaDoubleRefTranlocal take(BetaDoubleRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedBetaDoubleRef == -1) {
            return new BetaDoubleRefTranlocal(owner);
        }
        BetaDoubleRefTranlocal tranlocal = this.tranlocalsBetaDoubleRef[this.lastUsedBetaDoubleRef];
        tranlocal.owner = owner;
        this.tranlocalsBetaDoubleRef[this.lastUsedBetaDoubleRef] = null;
        --this.lastUsedBetaDoubleRef;
        return tranlocal;
    }

    public void put(BetaDoubleRefTranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedBetaDoubleRef == this.tranlocalsBetaDoubleRef.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++this.lastUsedBetaDoubleRef;
        this.tranlocalsBetaDoubleRef[this.lastUsedBetaDoubleRef] = tranlocal;
    }

    public BetaLongRefTranlocal take(BetaLongRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedBetaLongRef == -1) {
            return new BetaLongRefTranlocal(owner);
        }
        BetaLongRefTranlocal tranlocal = this.tranlocalsBetaLongRef[this.lastUsedBetaLongRef];
        tranlocal.owner = owner;
        this.tranlocalsBetaLongRef[this.lastUsedBetaLongRef] = null;
        --this.lastUsedBetaLongRef;
        return tranlocal;
    }

    public void put(BetaLongRefTranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedBetaLongRef == this.tranlocalsBetaLongRef.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++this.lastUsedBetaLongRef;
        this.tranlocalsBetaLongRef[this.lastUsedBetaLongRef] = tranlocal;
    }

    public BetaTranlocal take(BetaTransactionalObject owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        int classIndex = owner.___getClassIndex();
        if (classIndex == -1) {
            return owner.___newTranlocal();
        }
        switch (classIndex) {
            case 0: {
                return this.take((BetaRef)owner);
            }
            case 1: {
                return this.take((BetaIntRef)owner);
            }
            case 2: {
                return this.take((BetaBooleanRef)owner);
            }
            case 3: {
                return this.take((BetaDoubleRef)owner);
            }
            case 4: {
                return this.take((BetaLongRef)owner);
            }
        }
        if (classIndex >= this.pools.length) {
            return owner.___newTranlocal();
        }
        TranlocalPool pool = this.pools[classIndex];
        if (pool.lastUsed == -1) {
            return owner.___newTranlocal();
        }
        BetaTranlocal tranlocal = pool.tranlocals[pool.lastUsed];
        tranlocal.owner = owner;
        pool.tranlocals[pool.lastUsed] = null;
        --pool.lastUsed;
        return tranlocal;
    }

    public void put(BetaTranlocal tranlocal) {
        TranlocalPool pool;
        if (!this.tranlocalPoolingEnabled || tranlocal == null) {
            return;
        }
        BetaTransactionalObject owner = tranlocal.owner;
        int classIndex = owner.___getClassIndex();
        if (classIndex == -1) {
            return;
        }
        switch (classIndex) {
            case 0: {
                this.put((BetaRefTranlocal)tranlocal);
                return;
            }
            case 1: {
                this.put((BetaIntRefTranlocal)tranlocal);
                return;
            }
            case 2: {
                this.put((BetaBooleanRefTranlocal)tranlocal);
                return;
            }
            case 3: {
                this.put((BetaDoubleRefTranlocal)tranlocal);
                return;
            }
            case 4: {
                this.put((BetaLongRefTranlocal)tranlocal);
                return;
            }
        }
        if (classIndex >= this.pools.length) {
            TranlocalPool[] newPools = new TranlocalPool[this.pools.length * 2];
            System.arraycopy(this.pools, 0, newPools, 0, this.pools.length);
            this.pools = newPools;
        }
        if ((pool = this.pools[classIndex]) == null) {
            this.pools[classIndex] = pool = new TranlocalPool();
        }
        if (pool.lastUsed == pool.tranlocals.length - 1) {
            return;
        }
        tranlocal.prepareForPooling(this);
        ++pool.lastUsed;
        pool.tranlocals[pool.lastUsed] = tranlocal;
    }

    public void putTranlocalArray(BetaTranlocal[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!this.tranlocalArrayPoolingEnabled) {
            return;
        }
        if (array.length - 1 > this.tranlocalArrayPool.length) {
            return;
        }
        int index = array.length;
        if (this.tranlocalArrayPool[index] != null) {
            return;
        }
        for (int k = 0; k < array.length; ++k) {
            array[k] = null;
        }
        this.tranlocalArrayPool[index] = array;
    }

    public BetaTranlocal[] takeTranlocalArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.tranlocalArrayPoolingEnabled) {
            return new BetaTranlocal[size];
        }
        int index = size;
        if (index >= this.tranlocalArrayPool.length) {
            return new BetaTranlocal[size];
        }
        if (this.tranlocalArrayPool[index] == null) {
            return new BetaTranlocal[size];
        }
        BetaTranlocal[] array = this.tranlocalArrayPool[index];
        this.tranlocalArrayPool[index] = null;
        return array;
    }

    public CallableNode takeCallableNode() {
        if (!this.callableNodePoolingEnabled || this.callableNodePoolIndex == -1) {
            return new CallableNode();
        }
        CallableNode node = this.callableNodePool[this.callableNodePoolIndex];
        this.callableNodePool[this.callableNodePoolIndex] = null;
        --this.callableNodePoolIndex;
        return node;
    }

    public void putCallableNode(CallableNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.callableNodePoolingEnabled || this.callableNodePoolIndex == this.callableNodePool.length - 1) {
            return;
        }
        node.prepareForPooling();
        ++this.callableNodePoolIndex;
        this.callableNodePool[this.callableNodePoolIndex] = node;
    }

    public DefaultRetryLatch takeDefaultRetryLatch() {
        if (!this.latchPoolingEnabled || this.defaultRetryLatchPoolIndex == -1) {
            return new DefaultRetryLatch();
        }
        DefaultRetryLatch latch = this.defaultRetryLatchPool[this.defaultRetryLatchPoolIndex];
        this.defaultRetryLatchPool[this.defaultRetryLatchPoolIndex] = null;
        --this.defaultRetryLatchPoolIndex;
        return latch;
    }

    public void putDefaultRetryLatch(DefaultRetryLatch latch) {
        if (latch == null) {
            throw new NullPointerException();
        }
        if (!this.latchPoolingEnabled || this.defaultRetryLatchPoolIndex == this.defaultRetryLatchPool.length - 1) {
            return;
        }
        latch.prepareForPooling();
        ++this.defaultRetryLatchPoolIndex;
        this.defaultRetryLatchPool[this.defaultRetryLatchPoolIndex] = latch;
    }

    public ArrayList takeArrayList() {
        if (!this.arrayListPoolingEnabled || this.arrayListPoolIndex == -1) {
            return new ArrayList();
        }
        ArrayList list = this.arrayListPool[this.arrayListPoolIndex];
        this.arrayListPool[this.arrayListPoolIndex] = null;
        --this.arrayListPoolIndex;
        return list;
    }

    public void putArrayList(ArrayList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (!this.arrayListPoolingEnabled || this.arrayListPoolIndex == this.arrayListPool.length - 1) {
            return;
        }
        list.clear();
        ++this.arrayListPoolIndex;
        this.arrayListPool[this.arrayListPoolIndex] = list;
    }

    public Listeners takeListeners() {
        if (!this.listenersPoolingEnabled || this.listenersPoolIndex == -1) {
            return new Listeners();
        }
        Listeners listeners = this.listenersPool[this.listenersPoolIndex];
        this.listenersPool[this.listenersPoolIndex] = null;
        --this.listenersPoolIndex;
        return listeners;
    }

    public void putListeners(Listeners listeners) {
        if (listeners == null) {
            throw new NullPointerException();
        }
        if (!this.listenersPoolingEnabled || this.listenersPoolIndex == this.listenersPool.length - 1) {
            return;
        }
        listeners.prepareForPooling();
        ++this.listenersPoolIndex;
        this.listenersPool[this.listenersPoolIndex] = listeners;
    }

    public Listeners[] takeListenersArray(int minimalSize) {
        if (minimalSize < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.listenersArrayPoolingEnabled) {
            return new Listeners[minimalSize];
        }
        if (this.listenersArray == null || this.listenersArray.length < minimalSize) {
            return new Listeners[minimalSize];
        }
        Listeners[] result = this.listenersArray;
        this.listenersArray = null;
        return result;
    }

    public void putListenersArray(Listeners[] listenersArray) {
        if (listenersArray == null) {
            throw new NullPointerException();
        }
        if (!this.listenersArrayPoolingEnabled) {
            return;
        }
        if (this.listenersArray != listenersArray) {
            return;
        }
        this.listenersArray = listenersArray;
    }

    static class TranlocalPool {
        int lastUsed = -1;
        BetaTranlocal[] tranlocals = new BetaTranlocal[100];

        TranlocalPool() {
        }
    }
}

