/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta;

import org.multiverse.api.AtomicBlock;
import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.OrElseBlock;
import org.multiverse.api.PessimisticLockLevel;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.Stm;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.sensors.Profiler;
import org.multiverse.sensors.SimpleProfiler;
import org.multiverse.stms.beta.BetaStmConfiguration;
import org.multiverse.stms.beta.BetaTransactionFactory;
import org.multiverse.stms.beta.BetaTransactionFactoryBuilder;
import org.multiverse.stms.beta.FatBetaAtomicBlock;
import org.multiverse.stms.beta.LeanBetaAtomicBlock;
import org.multiverse.stms.beta.ThreadLocalBetaTransactionPool;
import org.multiverse.stms.beta.conflictcounters.GlobalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefFactory;
import org.multiverse.stms.beta.transactionalobjects.BetaRefFactoryBuilder;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;
import org.multiverse.stms.beta.transactions.BetaTransactionPool;
import org.multiverse.stms.beta.transactions.FatArrayBetaTransaction;
import org.multiverse.stms.beta.transactions.FatArrayTreeBetaTransaction;
import org.multiverse.stms.beta.transactions.FatMonoBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanArrayBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanArrayTreeBetaTransaction;
import org.multiverse.stms.beta.transactions.LeanMonoBetaTransaction;
import org.multiverse.stms.beta.transactions.SpeculativeBetaConfiguration;

public final class BetaStm
implements Stm {
    public final AtomicBlock defaultAtomicBlock;
    public final GlobalConflictCounter globalConflictCounter;
    public final int spinCount;
    public final BetaTransactionConfiguration defaultConfig;
    public final SimpleProfiler profiler = new SimpleProfiler();
    public final BackoffPolicy defaultBackoffPolicy;
    public final int defaultMaxRetries;
    public final BetaRefFactoryImpl defaultRefFactory = new BetaRefFactoryImpl();

    public static BetaStm createFast() {
        return new BetaStm(new BetaStmConfiguration());
    }

    public BetaStm() {
        this(new BetaStmConfiguration());
    }

    public BetaStm(BetaStmConfiguration configuration) {
        configuration.validate();
        this.spinCount = configuration.spinCount;
        this.defaultMaxRetries = configuration.maxRetries;
        this.defaultBackoffPolicy = configuration.backoffPolicy;
        this.globalConflictCounter = new GlobalConflictCounter(1);
        this.defaultConfig = new BetaTransactionConfiguration(this, configuration).setSpinCount(this.spinCount);
        this.defaultAtomicBlock = this.createTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).buildAtomicBlock();
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public BetaTransactionFactoryBuilder createTransactionFactoryBuilder() {
        return new BetaTransactionFactoryBuilderImpl(this.defaultConfig);
    }

    @Override
    public BetaRefFactoryBuilder getReferenceFactoryBuilder() {
        return new BetaRefFactoryBuilderImpl();
    }

    public GlobalConflictCounter getGlobalConflictCounter() {
        return this.globalConflictCounter;
    }

    @Override
    public BetaTransaction startDefaultTransaction() {
        return new FatArrayTreeBetaTransaction(this.defaultConfig);
    }

    @Override
    public AtomicBlock getDefaultAtomicBlock() {
        return this.defaultAtomicBlock;
    }

    @Override
    public BetaRefFactory getDefaultRefFactory() {
        return this.defaultRefFactory;
    }

    @Override
    public OrElseBlock createOrElseBlock() {
        throw new TodoException();
    }

    public final class SpeculativeBetaTransactionFactory
    implements BetaTransactionFactory {
        private final BetaTransactionConfiguration config;

        SpeculativeBetaTransactionFactory(BetaTransactionConfiguration config) {
            this.config = config;
        }

        @Override
        public BetaTransactionConfiguration getTransactionConfiguration() {
            return this.config;
        }

        @Override
        public BetaTransaction newTransaction() {
            return this.newTransaction(ThreadLocalBetaTransactionPool.getThreadLocalBetaTransactionPool());
        }

        @Override
        public BetaTransaction upgradeAfterSpeculativeFailure(BetaTransaction failingTransaction, BetaTransactionPool pool) {
            BetaTransaction tx = this.newTransaction(pool);
            tx.copyForSpeculativeFailure(failingTransaction);
            return tx;
        }

        @Override
        public BetaTransaction newTransaction(BetaTransactionPool pool) {
            SpeculativeBetaConfiguration speculativeConfiguration = this.config.speculativeConfiguration.get();
            int length = speculativeConfiguration.minimalLength;
            if (length <= 1) {
                if (speculativeConfiguration.isFat) {
                    FatMonoBetaTransaction tx = pool.takeFatMonoBetaTransaction();
                    if (tx == null) {
                        return new FatMonoBetaTransaction(this.config);
                    }
                    tx.init(this.config);
                    return tx;
                }
                LeanMonoBetaTransaction tx = pool.takeLeanMonoBetaTransaction();
                if (tx == null) {
                    return new LeanMonoBetaTransaction(this.config);
                }
                tx.init(this.config);
                return tx;
            }
            if (length <= this.config.maxArrayTransactionSize) {
                if (speculativeConfiguration.isFat) {
                    FatArrayBetaTransaction tx = pool.takeFatArrayBetaTransaction();
                    if (tx == null) {
                        return new FatArrayBetaTransaction(this.config);
                    }
                    tx.init(this.config);
                    return tx;
                }
                LeanArrayBetaTransaction tx = pool.takeLeanArrayBetaTransaction();
                if (tx == null) {
                    return new LeanArrayBetaTransaction(this.config);
                }
                tx.init(this.config);
                return tx;
            }
            if (speculativeConfiguration.isFat) {
                FatArrayTreeBetaTransaction tx = pool.takeFatArrayTreeBetaTransaction();
                if (tx == null) {
                    return new FatArrayTreeBetaTransaction(this.config);
                }
                tx.init(this.config);
                return tx;
            }
            LeanArrayTreeBetaTransaction tx = pool.takeLeanArrayTreeBetaTransaction();
            if (tx == null) {
                return new LeanArrayTreeBetaTransaction(this.config);
            }
            tx.init(this.config);
            return tx;
        }
    }

    public final class NonSpeculativeBetaTransactionFactory
    implements BetaTransactionFactory {
        private final BetaTransactionConfiguration config;

        NonSpeculativeBetaTransactionFactory(BetaTransactionConfiguration config) {
            this.config = config;
        }

        @Override
        public BetaTransactionConfiguration getTransactionConfiguration() {
            return this.config;
        }

        @Override
        public BetaTransaction newTransaction() {
            return this.newTransaction(ThreadLocalBetaTransactionPool.getThreadLocalBetaTransactionPool());
        }

        @Override
        public BetaTransaction newTransaction(BetaTransactionPool pool) {
            FatArrayTreeBetaTransaction tx = pool.takeFatArrayTreeBetaTransaction();
            if (tx == null) {
                tx = new FatArrayTreeBetaTransaction(this.config);
            } else {
                tx.init(this.config);
            }
            return tx;
        }

        @Override
        public BetaTransaction upgradeAfterSpeculativeFailure(BetaTransaction failingTransaction, BetaTransactionPool pool) {
            throw new UnsupportedOperationException();
        }
    }

    public final class BetaTransactionFactoryBuilderImpl
    implements BetaTransactionFactoryBuilder {
        private final BetaTransactionConfiguration config;

        BetaTransactionFactoryBuilderImpl(BetaTransactionConfiguration config) {
            this.config = config;
        }

        @Override
        public BetaTransactionConfiguration getTransactionConfiguration() {
            return this.config;
        }

        @Override
        public BetaTransactionFactoryBuilder addPermanentListener(TransactionLifecycleListener listener) {
            return new BetaTransactionFactoryBuilderImpl(this.config.addPermanentListener(listener));
        }

        @Override
        public BetaTransactionFactoryBuilder setFamilyName(String familyName) {
            if (this.config.familyName.equals(familyName)) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setFamilyName(familyName));
        }

        @Override
        public BetaTransactionFactoryBuilder setPropagationLevel(PropagationLevel level) {
            if (level == this.config.propagationLevel) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setPropagationLevel(level));
        }

        @Override
        public BetaTransactionFactoryBuilder setBlockingAllowed(boolean blockingAllowed) {
            if (blockingAllowed == this.config.blockingAllowed) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setBlockingAllowed(blockingAllowed));
        }

        @Override
        public BetaTransactionFactoryBuilder setIsolationLevel(IsolationLevel isolationLevel) {
            if (isolationLevel == this.config.isolationLevel) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setIsolationLevel(isolationLevel));
        }

        @Override
        public BetaTransactionFactoryBuilder setTraceLevel(TraceLevel traceLevel) {
            if (traceLevel == this.config.traceLevel) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setTraceLevel(traceLevel));
        }

        @Override
        public BetaTransactionFactoryBuilder setTimeoutNs(long timeoutNs) {
            if (timeoutNs == this.config.timeoutNs) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setTimeoutNs(timeoutNs));
        }

        @Override
        public BetaTransactionFactoryBuilder setInterruptible(boolean interruptible) {
            if (interruptible == this.config.interruptible) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setInterruptible(interruptible));
        }

        @Override
        public BetaTransactionFactoryBuilder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == this.config.backoffPolicy) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setBackoffPolicy(backoffPolicy));
        }

        @Override
        public BetaTransactionFactoryBuilder setPessimisticLockLevel(PessimisticLockLevel lockLevel) {
            if (lockLevel == this.config.pessimisticLockLevel) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setPessimisticLockLevel(lockLevel));
        }

        @Override
        public BetaTransactionFactoryBuilder setDirtyCheckEnabled(boolean dirtyCheckEnabled) {
            if (dirtyCheckEnabled == this.config.dirtyCheck) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setDirtyCheckEnabled(dirtyCheckEnabled));
        }

        @Override
        public BetaTransactionFactoryBuilder setSpinCount(int spinCount) {
            if (spinCount == this.config.spinCount) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setSpinCount(spinCount));
        }

        @Override
        public BetaTransactionFactoryBuilder setSpeculativeConfigurationEnabled(boolean enabled) {
            if (enabled == this.config.speculativeConfigEnabled) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setSpeculativeConfigurationEnabled(enabled));
        }

        @Override
        public BetaTransactionFactoryBuilder setReadonly(boolean readonly) {
            if (readonly == this.config.readonly) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setReadonly(readonly));
        }

        @Override
        public BetaTransactionFactoryBuilder setReadTrackingEnabled(boolean enabled) {
            if (enabled == this.config.trackReads) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setReadTrackingEnabled(enabled));
        }

        @Override
        public BetaTransactionFactoryBuilder setMaxRetries(int maxRetries) {
            if (maxRetries == this.config.maxRetries) {
                return this;
            }
            return new BetaTransactionFactoryBuilderImpl(this.config.setMaxRetries(maxRetries));
        }

        @Override
        public AtomicBlock buildAtomicBlock() {
            this.config.init();
            if (this.leanAtomicBlock()) {
                return new LeanBetaAtomicBlock(this.build());
            }
            return new FatBetaAtomicBlock(this.build());
        }

        private boolean leanAtomicBlock() {
            return this.config.propagationLevel == PropagationLevel.Requires;
        }

        @Override
        public BetaTransactionFactory build() {
            this.config.init();
            if (this.config.isSpeculativeConfigEnabled()) {
                return new SpeculativeBetaTransactionFactory(this.config);
            }
            return new NonSpeculativeBetaTransactionFactory(this.config);
        }
    }

    public final class BetaRefFactoryImpl
    implements BetaRefFactory {
        @Override
        public BetaBooleanRef newBooleanRef(boolean value) {
            return new BetaBooleanRef(BetaStm.this, value);
        }

        @Override
        public BetaDoubleRef newDoubleRef(double value) {
            return new BetaDoubleRef(BetaStm.this, value);
        }

        @Override
        public BetaIntRef newIntRef(int value) {
            return new BetaIntRef(BetaStm.this, value);
        }

        @Override
        public BetaLongRef newLongRef(long value) {
            return new BetaLongRef(BetaStm.this, value);
        }

        @Override
        public <E> BetaRef<E> newRef(E value) {
            return new BetaRef<E>(BetaStm.this, value);
        }
    }

    public final class BetaRefFactoryBuilderImpl
    implements BetaRefFactoryBuilder {
        @Override
        public BetaRefFactory build() {
            return new BetaRefFactoryImpl();
        }
    }
}

