/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import java.util.ArrayList;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public abstract class AbstractLeanBetaTransaction
extends BetaTransaction {
    public AbstractLeanBetaTransaction(int poolTransactionType, BetaTransactionConfiguration config) {
        super(poolTransactionType, config);
    }

    @Override
    public final ArrayList<TransactionLifecycleListener> getNormalListeners() {
        return null;
    }

    @Override
    public final void copyForSpeculativeFailure(BetaTransaction tx) {
        this.remainingTimeoutNs = tx.getRemainingTimeoutNs();
        this.attempt = tx.getAttempt();
    }

    @Override
    public final void register(TransactionLifecycleListener listener) {
        if (listener == null) {
            this.abort();
            throw new NullPointerException();
        }
        switch (this.status) {
            case 0: 
            case 1: 
            case 2: {
                this.config.needsListeners();
                this.abort();
                throw SpeculativeConfigurationError.INSTANCE;
            }
            case 4: {
                throw new DeadTransactionException();
            }
            case 3: {
                throw new DeadTransactionException();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final void startEitherBranch() {
        this.config.needsOrelse();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final void endEitherBranch() {
        this.abort();
        throw new IllegalStateException();
    }

    @Override
    public final void startOrElseBranch() {
        this.abort();
        throw new IllegalStateException();
    }
}

