/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import org.multiverse.api.IsolationLevel;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.AbstractFatBetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public final class FatMonoBetaTransaction
extends AbstractFatBetaTransaction {
    private BetaTranlocal attached;
    private boolean hasReads;
    private boolean hasUntrackedReads;
    private LocalConflictCounter localConflictCounter;
    private boolean evaluatingCommute;

    public FatMonoBetaTransaction(BetaStm stm) {
        this(new BetaTransactionConfiguration(stm).init());
    }

    public FatMonoBetaTransaction(BetaTransactionConfiguration config) {
        super(1, config);
        this.remainingTimeoutNs = config.timeoutNs;
        this.localConflictCounter = config.globalConflictCounter.createLocalConflictCounter();
    }

    @Override
    public final LocalConflictCounter getLocalConflictCounter() {
        return this.localConflictCounter;
    }

    @Override
    public final boolean tryLock(BetaTransactionalObject ref, int lockMode) {
        throw new TodoException();
    }

    @Override
    public void ensureWrites() {
        if (this.status != 1) {
            throw this.abortEnsureWrites();
        }
        if (this.config.writeLockMode != 0) {
            return;
        }
        if (this.attached == null || this.attached.isReadonly()) {
            return;
        }
        if (!this.attached.owner.___tryLockAndCheckConflict(this, this.config.spinCount, this.attached, false)) {
            throw this.abortOnReadConflict();
        }
    }

    @Override
    public final <E> E read(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> void flattenCommute(BetaRef<E> ref, BetaRefTranlocal<E> tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final <E> BetaRefTranlocal<E> open(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaRefTranlocal)this.attached;
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForRead(BetaRef<E> ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForWrite(BetaRef<E> ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForConstruction(BetaRef<E> ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public <E> void commute(BetaRef<E> ref, Function<E> function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final int read(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaIntRef ref, BetaIntRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaIntRefTranlocal open(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaIntRefTranlocal)this.attached;
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForRead(BetaIntRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaIntRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForWrite(BetaIntRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaIntRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForConstruction(BetaIntRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaIntRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaIntRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaIntRef ref, IntFunction function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaIntRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final boolean read(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaBooleanRef ref, BetaBooleanRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaBooleanRefTranlocal open(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaBooleanRefTranlocal)this.attached;
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForRead(BetaBooleanRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaBooleanRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForWrite(BetaBooleanRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaBooleanRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForConstruction(BetaBooleanRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaBooleanRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaBooleanRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaBooleanRef ref, BooleanFunction function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final double read(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaDoubleRef ref, BetaDoubleRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaDoubleRefTranlocal open(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaDoubleRefTranlocal)this.attached;
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForRead(BetaDoubleRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaDoubleRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForWrite(BetaDoubleRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaDoubleRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForConstruction(BetaDoubleRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaDoubleRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaDoubleRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaDoubleRef ref, DoubleFunction function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    @Override
    public final long read(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        this.hasUntrackedReads = true;
        return ref.atomicWeakGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaLongRef ref, BetaLongRefTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaLongRefTranlocal open(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaLongRefTranlocal)this.attached;
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForRead(BetaLongRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaLongRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForWrite(BetaLongRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaLongRefTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForConstruction(BetaLongRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaLongRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaLongRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaLongRef ref, LongFunction function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaLongRefTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        tranlocal.value = function.call(tranlocal.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenCommute(BetaTransactionalObject ref, BetaTranlocal tranlocal, int lockMode) {
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (this.hasReadConflict()) {
            throw this.abortOnReadConflict();
        }
        boolean abort = true;
        this.evaluatingCommute = true;
        try {
            tranlocal.evaluateCommutingFunctions(this.pool);
            abort = false;
        }
        finally {
            this.evaluatingCommute = false;
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final BetaTranlocal open(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.getStm() != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return this.attached;
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForRead(BetaTransactionalObject ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForReadWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (this.hasReadConflict()) {
                ref.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            if (lockMode != 0 || tranlocal.hasDepartObligation() || this.config.trackReads) {
                this.attached = tranlocal;
            } else {
                this.hasUntrackedReads = true;
            }
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaTranlocal tranlocal = this.attached;
            if (tranlocal.isCommuting()) {
                this.flattenCommute(ref, tranlocal, lockMode);
                return tranlocal;
            }
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        if (!this.hasReads) {
            this.localConflictCounter.reset();
            this.hasReads = true;
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.hasDepartObligation()) {
            this.pool.put(tranlocal);
            throw this.abortOnTooSmallSize(2);
        }
        if (this.hasReadConflict()) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            throw this.abortOnReadConflict();
        }
        this.hasUntrackedReads = true;
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForWrite(BetaTransactionalObject ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForWriteWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaTranlocal tranlocal;
            if (!this.hasReads) {
                this.localConflictCounter.reset();
                this.hasReads = true;
            }
            if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal = this.pool.take(ref))) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            if (this.hasReadConflict()) {
                tranlocal.owner.___abort(this, tranlocal, this.pool);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal.isCommuting()) {
            this.flattenCommute(ref, tranlocal, lockMode);
            return tranlocal;
        }
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForConstruction(BetaTransactionalObject ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnOpenForConstructionWhileEvaluatingCommute(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaTransactionalObject ref, Function function) {
        boolean contains;
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        if (this.evaluatingCommute) {
            throw this.abortOnCommuteWhileEvaluatingCommute(ref);
        }
        if (this.config.readonly) {
            throw this.abortCommuteWhenReadonly(ref, function);
        }
        if (ref == null) {
            throw this.abortCommuteWhenNullReference(function);
        }
        boolean bl = contains = this.attached != null && this.attached.owner == ref;
        if (!contains) {
            if (this.attached != null) {
                throw this.abortOnTooSmallSize(2);
            }
            BetaTranlocal tranlocal = this.pool.take(ref);
            tranlocal.tx = this;
            tranlocal.setStatus(3);
            tranlocal.addCommutingFunction(function, this.pool);
            this.attached = tranlocal;
            this.hasUpdates = true;
            return;
        }
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal.isCommuting()) {
            tranlocal.addCommutingFunction(function, this.pool);
            return;
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        throw new TodoException();
    }

    @Override
    public BetaTranlocal get(BetaTransactionalObject object) {
        return this.attached == null || this.attached.owner != object ? null : this.attached;
    }

    @Override
    public BetaTranlocal locate(BetaTransactionalObject owner) {
        if (this.status != 1) {
            throw this.abortLocate(owner);
        }
        if (owner == null) {
            throw this.abortLocateWhenNullReference();
        }
        return this.attached == null || this.attached.owner != owner ? null : this.attached;
    }

    private boolean hasReadConflict() {
        if (this.config.readLockMode != 0 || this.config.inconsistentReadAllowed) {
            return false;
        }
        if (this.hasUntrackedReads) {
            return this.localConflictCounter.syncAndCheckConflict();
        }
        if (this.attached == null) {
            return false;
        }
        if (!this.localConflictCounter.syncAndCheckConflict()) {
            return false;
        }
        return this.attached.owner.___hasReadConflict(this.attached);
    }

    @Override
    public final void abort() {
        if (this.status != 1 && this.status != 2) {
            switch (this.status) {
                case 3: {
                    return;
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.abort, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal != null) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            this.attached = null;
        }
        this.status = 3;
        if (this.config.permanentListeners != null) {
            this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostAbort);
        }
        if (this.normalListeners != null) {
            this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostAbort);
        }
    }

    @Override
    public final void commit() {
        if (this.status == 4) {
            return;
        }
        this.prepare();
        Listeners listeners = null;
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal != null) {
            if (this.config.dirtyCheck) {
                if (!tranlocal.isReadonly() && !tranlocal.isDirty()) {
                    tranlocal.calculateIsDirty();
                }
                listeners = this.attached.owner.___commitDirty(tranlocal, this, this.pool);
            } else {
                listeners = this.attached.owner.___commitAll(tranlocal, this, this.pool);
            }
            this.attached = null;
        }
        this.status = 4;
        if (listeners != null) {
            listeners.openAll(this.pool);
        }
        if (this.config.permanentListeners != null) {
            this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostCommit);
        }
        if (this.normalListeners != null) {
            this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepare() {
        if (this.status != 1) {
            switch (this.status) {
                case 2: {
                    return;
                }
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        boolean abort = true;
        try {
            if (this.config.permanentListeners != null) {
                this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PrePrepare);
            }
            if (this.normalListeners != null) {
                this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PrePrepare);
            }
            if (this.abortOnly) {
                throw this.abortOnWriteConflict();
            }
            if (this.hasUpdates && this.config.readLockMode != 2) {
                boolean success;
                boolean bl = success = this.config.dirtyCheck ? this.attached.prepareDirtyUpdates(this.pool, this, this.config.spinCount) : this.attached.prepareAllUpdates(this.pool, this, this.config.spinCount);
                if (!success) {
                    throw this.abortOnWriteConflict();
                }
            }
            this.status = 2;
            abort = false;
        }
        finally {
            if (abort) {
                this.abort();
            }
        }
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortOnFaultyStatusOfRetry();
        }
        if (!this.config.blockingAllowed) {
            throw this.abortOnNoBlockingAllowed();
        }
        if (this.attached == null) {
            throw this.abortOnNoRetryPossible();
        }
        DefaultRetryLatch listener = this.pool.takeDefaultRetryLatch();
        try {
            long listenerEra = listener.getEra();
            BetaTransactionalObject owner = this.attached.owner;
            boolean noRegistration = owner.___registerChangeListener(listener, this.attached, this.pool, listenerEra) == 2;
            owner.___abort(this, this.attached, this.pool);
            this.attached = null;
            this.status = 3;
            if (this.config.permanentListeners != null) {
                this.notifyListeners(this.config.permanentListeners, TransactionLifecycleEvent.PostAbort);
            }
            if (this.normalListeners != null) {
                this.notifyListeners(this.normalListeners, TransactionLifecycleEvent.PostAbort);
            }
            if (noRegistration) {
                throw this.abortOnNoRetryPossible();
            }
            this.awaitUpdate(listener);
            throw Retry.INSTANCE;
        }
        catch (Throwable throwable) {
            this.pool.putDefaultRetryLatch(listener);
            throw throwable;
        }
    }

    @Override
    public void init(BetaTransactionConfiguration transactionConfig) {
        if (transactionConfig == null) {
            this.abort();
            throw new NullPointerException();
        }
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.config = transactionConfig;
        this.hardReset();
    }

    @Override
    public boolean softReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.status = 1;
        this.hasUpdates = false;
        ++this.attempt;
        this.abortOnly = false;
        this.evaluatingCommute = false;
        this.hasReads = false;
        this.hasUntrackedReads = false;
        if (this.normalListeners != null) {
            this.normalListeners.clear();
        }
        return true;
    }

    @Override
    public void hardReset() {
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.hasUpdates = false;
        this.status = 1;
        this.abortOnly = false;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.attempt = 1;
        this.evaluatingCommute = false;
        this.hasReads = false;
        this.hasUntrackedReads = false;
        if (this.normalListeners != null) {
            this.pool.putArrayList(this.normalListeners);
            this.normalListeners = null;
        }
    }

    @Override
    public final void startEitherBranch() {
        throw new TodoException();
    }

    @Override
    public final void endEitherBranch() {
        throw new TodoException();
    }

    @Override
    public final void startOrElseBranch() {
        throw new TodoException();
    }
}

