/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import org.multiverse.api.IsolationLevel;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.stms.beta.BetaStm;
import org.multiverse.stms.beta.Listeners;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.AbstractLeanBetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransaction;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public final class LeanMonoBetaTransaction
extends AbstractLeanBetaTransaction {
    private BetaTranlocal attached;

    public LeanMonoBetaTransaction(BetaStm stm) {
        this(new BetaTransactionConfiguration(stm).init());
    }

    public LeanMonoBetaTransaction(BetaTransactionConfiguration config) {
        super(0, config);
        this.remainingTimeoutNs = config.timeoutNs;
    }

    @Override
    public final LocalConflictCounter getLocalConflictCounter() {
        return null;
    }

    @Override
    public final boolean tryLock(BetaTransactionalObject ref, int lockMode) {
        throw new TodoException();
    }

    @Override
    public void ensureWrites() {
        if (this.status != 1) {
            throw this.abortEnsureWrites();
        }
        if (this.config.writeLockMode != 0) {
            return;
        }
        if (this.attached == null || this.attached.isReadonly()) {
            return;
        }
        if (!this.attached.owner.___tryLockAndCheckConflict(this, this.config.spinCount, this.attached, false)) {
            throw this.abortOnReadConflict();
        }
    }

    @Override
    public final <E> E read(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final <E> BetaRefTranlocal<E> open(BetaRef<E> ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaRefTranlocal)this.attached;
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForRead(BetaRef<E> ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForWrite(BetaRef<E> ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaRefTranlocal tranlocal = (BetaRefTranlocal)this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final <E> BetaRefTranlocal<E> openForConstruction(BetaRef<E> ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public <E> void commute(BetaRef<E> ref, Function<E> function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final int read(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaIntRefTranlocal open(BetaIntRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaIntRefTranlocal)this.attached;
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForRead(BetaIntRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaIntRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaIntRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaIntRefTranlocal openForWrite(BetaIntRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaIntRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaIntRefTranlocal tranlocal = (BetaIntRefTranlocal)this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaIntRefTranlocal openForConstruction(BetaIntRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaIntRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaIntRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaIntRef ref, IntFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final boolean read(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaBooleanRefTranlocal open(BetaBooleanRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaBooleanRefTranlocal)this.attached;
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForRead(BetaBooleanRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaBooleanRefTranlocal openForWrite(BetaBooleanRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaBooleanRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaBooleanRefTranlocal tranlocal = (BetaBooleanRefTranlocal)this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaBooleanRefTranlocal openForConstruction(BetaBooleanRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaBooleanRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaBooleanRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaBooleanRef ref, BooleanFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final double read(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaDoubleRefTranlocal open(BetaDoubleRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaDoubleRefTranlocal)this.attached;
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForRead(BetaDoubleRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaDoubleRefTranlocal openForWrite(BetaDoubleRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaDoubleRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaDoubleRefTranlocal tranlocal = (BetaDoubleRefTranlocal)this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaDoubleRefTranlocal openForConstruction(BetaDoubleRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaDoubleRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaDoubleRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaDoubleRef ref, DoubleFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final long read(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortRead(ref);
        }
        if (ref == null) {
            throw this.abortReadOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortReadOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
            tranlocal.openForRead(this.config.readLockMode);
            return tranlocal.value;
        }
        if (this.config.trackReads || this.config.isolationLevel != IsolationLevel.ReadCommitted) {
            throw new TodoException();
        }
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaLongRefTranlocal open(BetaLongRef ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.___stm != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return (BetaLongRefTranlocal)this.attached;
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForRead(BetaLongRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaLongRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaLongRefTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaLongRefTranlocal openForWrite(BetaLongRef ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaLongRefTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, (BetaTransaction)this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaLongRefTranlocal tranlocal = (BetaLongRefTranlocal)this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaLongRefTranlocal openForConstruction(BetaLongRef ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : (BetaLongRefTranlocal)this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        ((BetaLongRefTranlocal)tranlocal).tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaLongRef ref, LongFunction function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public final BetaTranlocal open(BetaTransactionalObject ref) {
        if (this.status != 1) {
            throw this.abortOpen(ref);
        }
        if (ref == null) {
            throw this.abortOpenOnNull();
        }
        if (ref.getStm() != this.config.stm) {
            throw this.abortOnStmMismatch(ref);
        }
        if (this.attached != null && this.attached.owner == ref) {
            return this.attached;
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setIsConflictCheckNeeded(!this.config.writeSkewAllowed);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForRead(BetaTransactionalObject ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForRead(ref);
        }
        if (ref == null) {
            return null;
        }
        int n = lockMode = lockMode >= this.config.readLockMode ? lockMode : this.config.readLockMode;
        if (this.attached == null) {
            BetaTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(4);
            if (lockMode == 0 && !tranlocal.hasDepartObligation() && !this.config.trackReads) {
                throw this.abortOnTooSmallSize(2);
            }
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner == ref) {
            BetaTranlocal tranlocal = this.attached;
            if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
                throw this.abortOnReadConflict();
            }
            return tranlocal;
        }
        if (lockMode != 0 || this.config.trackReads) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaTranlocal tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setStatus(4);
        if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
            throw this.abortOnReadConflict();
        }
        this.pool.put(tranlocal);
        throw this.abortOnTooSmallSize(2);
    }

    @Override
    public final BetaTranlocal openForWrite(BetaTransactionalObject ref, int lockMode) {
        if (this.status != 1) {
            throw this.abortOpenForWrite(ref);
        }
        if (ref == null) {
            throw this.abortOpenForWriteWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForWriteWhenReadonly(ref);
        }
        int n = lockMode = lockMode >= this.config.writeLockMode ? lockMode : this.config.writeLockMode;
        if (this.attached == null) {
            BetaTranlocal tranlocal = this.pool.take(ref);
            if (!ref.___load(this.config.spinCount, this, lockMode, tranlocal)) {
                this.pool.put(tranlocal);
                throw this.abortOnReadConflict();
            }
            tranlocal.tx = this;
            tranlocal.setStatus(2);
            this.hasUpdates = true;
            this.attached = tranlocal;
            return tranlocal;
        }
        if (this.attached.owner != ref) {
            throw this.abortOnTooSmallSize(2);
        }
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal.getLockMode() < lockMode && !ref.___tryLockAndCheckConflict(this, this.config.spinCount, tranlocal, lockMode == 2)) {
            throw this.abortOnReadConflict();
        }
        if (tranlocal.isReadonly()) {
            tranlocal.setStatus(2);
            this.hasUpdates = true;
        }
        return tranlocal;
    }

    @Override
    public final BetaTranlocal openForConstruction(BetaTransactionalObject ref) {
        BetaTranlocal tranlocal;
        if (this.status != 1) {
            throw this.abortOpenForConstruction(ref);
        }
        if (ref == null) {
            throw this.abortOpenForConstructionWhenNullReference();
        }
        if (this.config.readonly) {
            throw this.abortOpenForConstructionWhenReadonly(ref);
        }
        BetaTranlocal betaTranlocal = tranlocal = this.attached == null || this.attached.owner != ref ? null : this.attached;
        if (tranlocal != null) {
            if (!tranlocal.isConstructing()) {
                throw this.abortOpenForConstructionWithBadReference(ref);
            }
            return tranlocal;
        }
        if (this.attached != null) {
            throw this.abortOnTooSmallSize(2);
        }
        if (ref.___getLockOwner() != this && ref.getVersion() != 0L) {
            throw this.abortOpenForConstructionWithBadReference(ref);
        }
        tranlocal = this.pool.take(ref);
        tranlocal.tx = this;
        tranlocal.setDirty(true);
        tranlocal.setLockMode(2);
        tranlocal.setStatus(1);
        this.attached = tranlocal;
        return tranlocal;
    }

    @Override
    public void commute(BetaTransactionalObject ref, Function function) {
        if (this.status != 1) {
            throw this.abortCommute(ref, function);
        }
        if (function == null) {
            throw this.abortCommuteOnNullFunction(ref);
        }
        this.config.needsCommute();
        this.abort();
        throw SpeculativeConfigurationError.INSTANCE;
    }

    @Override
    public BetaTranlocal get(BetaTransactionalObject object) {
        return this.attached == null || this.attached.owner != object ? null : this.attached;
    }

    @Override
    public BetaTranlocal locate(BetaTransactionalObject owner) {
        if (this.status != 1) {
            throw this.abortLocate(owner);
        }
        if (owner == null) {
            throw this.abortLocateWhenNullReference();
        }
        return this.attached == null || this.attached.owner != owner ? null : this.attached;
    }

    @Override
    public final void abort() {
        if (this.status != 1 && this.status != 2) {
            switch (this.status) {
                case 3: {
                    return;
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.abort, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        BetaTranlocal tranlocal = this.attached;
        if (tranlocal != null) {
            tranlocal.owner.___abort(this, tranlocal, this.pool);
            this.attached = null;
        }
        this.status = 3;
    }

    @Override
    public final void commit() {
        if (this.status != 1 && this.status != 2) {
            switch (this.status) {
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.commit, reason: the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    return;
                }
            }
            throw new IllegalStateException();
        }
        if (this.abortOnly) {
            throw this.abortOnWriteConflict();
        }
        BetaTranlocal tranlocal = this.attached;
        Listeners listeners = null;
        if (tranlocal != null) {
            if (tranlocal.ignore()) {
                this.pool.put(tranlocal);
            } else {
                boolean needsPrepare;
                boolean bl = needsPrepare = this.status == 1 && this.hasUpdates && this.config.readLockMode != 2;
                if (this.config.dirtyCheck) {
                    if (needsPrepare && !tranlocal.prepareDirtyUpdates(this.pool, this, this.config.spinCount)) {
                        throw this.abortOnWriteConflict();
                    }
                    if (!tranlocal.isReadonly() && !tranlocal.isDirty()) {
                        tranlocal.calculateIsDirty();
                    }
                    listeners = tranlocal.owner.___commitDirty(tranlocal, this, this.pool);
                } else {
                    if (needsPrepare && !tranlocal.prepareAllUpdates(this.pool, this, this.config.spinCount)) {
                        throw this.abortOnWriteConflict();
                    }
                    listeners = tranlocal.owner.___commitAll(tranlocal, this, this.pool);
                }
            }
            this.attached = null;
        }
        this.status = 4;
        if (listeners != null) {
            listeners.openAll(this.pool);
        }
    }

    @Override
    public final void prepare() {
        if (this.status != 1) {
            switch (this.status) {
                case 2: {
                    return;
                }
                case 3: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.prepare, reason: the transaction already is aborted", this.config.familyName));
                }
                case 4: {
                    throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.commit, reason: the transaction already is committed", this.config.familyName));
                }
            }
            throw new IllegalStateException();
        }
        if (this.abortOnly) {
            throw this.abortOnWriteConflict();
        }
        if (this.hasUpdates && this.config.readLockMode != 2) {
            boolean success;
            boolean bl = success = this.config.dirtyCheck ? this.attached.prepareDirtyUpdates(this.pool, this, this.config.spinCount) : this.attached.prepareAllUpdates(this.pool, this, this.config.spinCount);
            if (!success) {
                throw this.abortOnWriteConflict();
            }
        }
        this.status = 2;
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortOnFaultyStatusOfRetry();
        }
        if (!this.config.blockingAllowed) {
            throw this.abortOnNoBlockingAllowed();
        }
        if (this.attached == null) {
            throw this.abortOnNoRetryPossible();
        }
        DefaultRetryLatch listener = this.pool.takeDefaultRetryLatch();
        try {
            long listenerEra = listener.getEra();
            BetaTransactionalObject owner = this.attached.owner;
            boolean noRegistration = owner.___registerChangeListener(listener, this.attached, this.pool, listenerEra) == 2;
            owner.___abort(this, this.attached, this.pool);
            this.attached = null;
            this.status = 3;
            if (noRegistration) {
                throw this.abortOnNoRetryPossible();
            }
            this.awaitUpdate(listener);
            throw Retry.INSTANCE;
        }
        catch (Throwable throwable) {
            this.pool.putDefaultRetryLatch(listener);
            throw throwable;
        }
    }

    @Override
    public void init(BetaTransactionConfiguration transactionConfig) {
        if (transactionConfig == null) {
            this.abort();
            throw new NullPointerException();
        }
        if (this.status == 1 || this.status == 2) {
            this.abort();
        }
        this.config = transactionConfig;
        this.hardReset();
    }

    @Override
    public boolean softReset() {
        if ((this.status == 1 || this.status == 2) && this.attached != null) {
            this.attached.owner.___abort(this, this.attached, this.pool);
        }
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.status = 1;
        this.hasUpdates = false;
        ++this.attempt;
        this.abortOnly = false;
        return true;
    }

    @Override
    public void hardReset() {
        if ((this.status == 1 || this.status == 2) && this.attached != null) {
            this.attached.owner.___abort(this, this.attached, this.pool);
        }
        this.hasUpdates = false;
        this.status = 1;
        this.abortOnly = false;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.attempt = 1;
    }
}

