/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.ignite;

import java.io.File;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.mybatis.caches.ignite.DummyReadWriteLock;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class IgniteCacheAdapter
implements Cache {
    private static final Log log = LogFactory.getLog(IgniteCacheAdapter.class);
    private final String id;
    private final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    private static final Ignite ignite = Ignition.start();
    private final IgniteCache cache;
    private static final String cfgPath = "config/default-config.xml";

    public IgniteCacheAdapter(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        CacheConfiguration cacheCfg = null;
        try {
            DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)factory).loadBeanDefinitions((Resource)new FileSystemResource(new File(cfgPath)));
            cacheCfg = (CacheConfiguration)factory.getBean("templateCacheCfg");
            cacheCfg.setEvictionPolicy(null);
            cacheCfg.setCacheLoaderFactory(null);
            cacheCfg.setCacheWriterFactory(null);
            cacheCfg.setName(id);
        }
        catch (BeanDefinitionStoreException | NoSuchBeanDefinitionException e) {
            log.warn("Initializing the default cache. Consider properly configuring 'config/default-config.xml' instead.");
            cacheCfg = new CacheConfiguration(id);
        }
        this.cache = ignite.getOrCreateCache(cacheCfg);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        this.cache.put(key, value);
    }

    public Object getObject(Object key) {
        return this.cache.get(key);
    }

    public Object removeObject(Object key) {
        return this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public int getSize() {
        return this.cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY});
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

