/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.pool.FixedChannelPool;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.pool.AuthContext;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.handlers.LogoffResponseHandler;
import org.neo4j.driver.internal.handlers.LogonResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.request.LogoffMessage;
import org.neo4j.driver.internal.messaging.request.LogonMessage;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.SessionAuthUtil;

public class NettyChannelPool
implements ExtendedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = false;
    private final FixedChannelPool delegate;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String id;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final NettyChannelHealthChecker healthChecker;
    private final Clock clock;

    NettyChannelPool(final BoltServerAddress address, final ChannelConnector connector, Bootstrap bootstrap, final NettyChannelTracker handler, NettyChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections, Clock clock) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(connector);
        Objects.requireNonNull(handler);
        Objects.requireNonNull(clock);
        this.id = this.poolId(address);
        this.healthChecker = healthCheck;
        this.clock = clock;
        this.delegate = new FixedChannelPool(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, false){

            protected ChannelFuture connectChannel(Bootstrap bootstrap) {
                ListenerEvent<?> creatingEvent = handler.channelCreating(NettyChannelPool.this.id);
                return connector.connect(address, bootstrap, connectedChannelFuture -> {
                    Channel channel = connectedChannelFuture.channel();
                    ChannelPromise trackedChannelFuture = channel.newPromise();
                    connectedChannelFuture.addListener(future -> {
                        if (future.isSuccess()) {
                            ChannelAttributes.setPoolId(channel, NettyChannelPool.this.id);
                            handler.channelCreated(channel, creatingEvent);
                            trackedChannelFuture.setSuccess();
                        } else {
                            handler.channelFailedToCreate(NettyChannelPool.this.id);
                            trackedChannelFuture.setFailure(future.cause());
                        }
                    });
                    return trackedChannelFuture;
                });
            }
        };
    }

    @Override
    public CompletionStage<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            Futures.asCompletionStage(this.delegate.closeAsync(), this.closeFuture);
        }
        return this.closeFuture;
    }

    @Override
    public NettyChannelHealthChecker healthChecker() {
        return this.healthChecker;
    }

    @Override
    public CompletionStage<Channel> acquire(AuthToken overrideAuthToken) {
        return Futures.asCompletionStage(this.delegate.acquire()).thenCompose(channel -> this.auth((Channel)channel, overrideAuthToken));
    }

    private CompletionStage<Channel> auth(Channel channel, AuthToken overrideAuthToken) {
        CompletionStage<Object> authStage;
        AuthContext authContext = ChannelAttributes.authContext(channel);
        if (overrideAuthToken != null) {
            BoltProtocolVersion protocolVersion = ChannelAttributes.protocolVersion(channel);
            if (!SessionAuthUtil.supportsSessionAuth(protocolVersion)) {
                authStage = Futures.failedFuture(new UnsupportedFeatureException(String.format("Detected Bolt %s connection that does not support the auth token override feature, please make sure to have all servers communicating over Bolt 5.1 or above to use the feature", protocolVersion)));
            } else if (!overrideAuthToken.equals(authContext.getAuthToken())) {
                CompletableFuture logoffFuture;
                if (authContext.getAuthTimestamp() != null) {
                    logoffFuture = new CompletableFuture();
                    ChannelAttributes.messageDispatcher(channel).enqueue(new LogoffResponseHandler(logoffFuture));
                    channel.write((Object)LogoffMessage.INSTANCE);
                } else {
                    logoffFuture = null;
                }
                CompletableFuture logonFuture = new CompletableFuture();
                ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, this.clock));
                authContext.initiateAuth(overrideAuthToken, false);
                authContext.setValidToken(null);
                channel.write((Object)new LogonMessage(((InternalAuthToken)overrideAuthToken).toMap()));
                if (logoffFuture == null) {
                    authStage = ChannelAttributes.helloStage(channel).thenCompose(ignored -> logonFuture).thenApply(ignored -> channel);
                    channel.flush();
                } else {
                    authStage = CompletableFuture.completedStage(channel);
                }
            } else {
                authStage = CompletableFuture.completedStage(channel);
            }
        } else {
            AuthToken validToken = authContext.getValidToken();
            authContext.setValidToken(null);
            CompletionStage<AuthToken> stage = validToken != null ? CompletableFuture.completedStage(validToken) : authContext.getAuthTokenManager().getToken();
            authStage = stage.thenComposeAsync(latestAuthToken -> {
                CompletionStage<Channel> result;
                if (authContext.getAuthTimestamp() != null) {
                    if (!authContext.getAuthToken().equals(latestAuthToken) || authContext.isPendingLogoff()) {
                        CompletableFuture logoffFuture = new CompletableFuture();
                        ChannelAttributes.messageDispatcher(channel).enqueue(new LogoffResponseHandler(logoffFuture));
                        channel.write((Object)LogoffMessage.INSTANCE);
                        CompletableFuture logonFuture = new CompletableFuture();
                        ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, this.clock));
                        authContext.initiateAuth((AuthToken)latestAuthToken);
                        channel.write((Object)new LogonMessage(((InternalAuthToken)latestAuthToken).toMap()));
                    }
                    result = CompletableFuture.completedStage(channel);
                } else {
                    CompletableFuture logonFuture = new CompletableFuture();
                    ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, this.clock));
                    result = ChannelAttributes.helloStage(channel).thenCompose(ignored -> logonFuture).thenApply(ignored -> channel);
                    authContext.initiateAuth((AuthToken)latestAuthToken);
                    channel.writeAndFlush((Object)new LogonMessage(((InternalAuthToken)latestAuthToken).toMap()));
                }
                return result;
            }, (Executor)channel.eventLoop());
        }
        return authStage.handle((ignored, throwable) -> {
            if (throwable != null) {
                channel.close();
                this.release(channel);
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new CompletionException((Throwable)throwable);
            }
            return channel;
        });
    }

    @Override
    public CompletionStage<Void> release(Channel channel) {
        return Futures.asCompletionStage(this.delegate.release(channel));
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public String id() {
        return this.id;
    }

    private String poolId(BoltServerAddress serverAddress) {
        return String.format("%s:%d-%d", serverAddress.host(), serverAddress.port(), this.hashCode());
    }
}

