/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

public enum ResponseMessageType {
    TX(1),
    STORE_ID(2),
    FILE(3),
    STORE_COPY_FINISHED(4),
    CORE_SNAPSHOT(5),
    TX_STREAM_FINISHED(6),
    UNKNOWN(-56);

    private byte messageType;

    private ResponseMessageType(byte messageType) {
        this.messageType = messageType;
    }

    public static ResponseMessageType from(byte b) {
        for (ResponseMessageType responseMessageType : ResponseMessageType.values()) {
            if (responseMessageType.messageType != b) continue;
            return responseMessageType;
        }
        return UNKNOWN;
    }

    public byte messageType() {
        return this.messageType;
    }

    public String toString() {
        return String.format("ResponseMessageType{messageType=%s}", this.messageType);
    }
}

