/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.File;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.FileSender;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class GetStoreRequestHandler
extends SimpleChannelInboundHandler<GetStoreRequest> {
    private final CatchupServerProtocol protocol;
    private final Supplier<NeoStoreDataSource> dataSource;
    private final Supplier<CheckPointer> checkPointerSupplier;
    private final FileSystemAbstraction fs;
    private final Log log;

    public GetStoreRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, Supplier<CheckPointer> checkPointerSupplier, FileSystemAbstraction fs, LogProvider logProvider) {
        this.protocol = protocol;
        this.dataSource = dataSource;
        this.checkPointerSupplier = checkPointerSupplier;
        this.fs = fs;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetStoreRequest msg) throws Exception {
        if (!msg.expectedStoreId().equalToKernelStoreId(this.dataSource.get().getStoreId())) {
            this.endStoreCopy(StoreCopyFinishedResponse.Status.SUCCESS, ctx, -1L);
        } else {
            long lastCheckPointedTx = this.checkPointerSupplier.get().tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("Store copy"));
            try (ResourceIterator files = this.dataSource.get().listStoreFiles(false);){
                while (files.hasNext()) {
                    File file = ((StoreFileMetadata)files.next()).file();
                    this.log.debug("Sending file " + file);
                    ctx.writeAndFlush((Object)ResponseMessageType.FILE);
                    ctx.writeAndFlush((Object)new FileHeader(FileUtils.relativePath((File)this.dataSource.get().getStoreDir(), (File)file)));
                    ctx.writeAndFlush((Object)new FileSender(this.fs.open(file, "r")));
                }
            }
            this.endStoreCopy(StoreCopyFinishedResponse.Status.SUCCESS, ctx, lastCheckPointedTx);
        }
        this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
    }

    private void endStoreCopy(StoreCopyFinishedResponse.Status status, ChannelHandlerContext ctx, long lastCommittedTxBeforeStoreCopy) {
        ctx.write((Object)ResponseMessageType.STORE_COPY_FINISHED);
        ctx.writeAndFlush((Object)new StoreCopyFinishedResponse(status, lastCommittedTxBeforeStoreCopy));
    }
}

