/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.TxPullRequestResult;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDisk;
import org.neo4j.causalclustering.catchup.storecopy.StreamingTransactionsFailedException;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreFetcher {
    private final Log log;
    private final Monitors monitors;
    private FileSystemAbstraction fs;
    private PageCache pageCache;
    private final LogProvider logProvider;
    private StoreCopyClient storeCopyClient;
    private TxPullClient txPullClient;
    private TransactionLogCatchUpFactory transactionLogFactory;

    public StoreFetcher(LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, StoreCopyClient storeCopyClient, TxPullClient txPullClient, TransactionLogCatchUpFactory transactionLogFactory, Monitors monitors) {
        this.logProvider = logProvider;
        this.storeCopyClient = storeCopyClient;
        this.txPullClient = txPullClient;
        this.fs = fs;
        this.pageCache = pageCache;
        this.transactionLogFactory = transactionLogFactory;
        this.log = logProvider.getLog(this.getClass());
        this.monitors = monitors;
    }

    public CatchupResult tryCatchingUp(MemberId from, StoreId expectedStoreId, File storeDir) throws StoreCopyFailedException, IOException {
        ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, storeDir);
        long lastCommittedTxId = transactionIdStore.getLastCommittedTransactionId();
        return this.pullTransactions(from, expectedStoreId, storeDir, lastCommittedTxId + 1L, false);
    }

    public void copyStore(MemberId from, StoreId expectedStoreId, File destDir) throws StoreCopyFailedException, StreamingTransactionsFailedException {
        try {
            this.log.info("Copying store from %s", new Object[]{from});
            long lastFlushedTxId = this.storeCopyClient.copyStoreFiles(from, expectedStoreId, new StreamToDisk(destDir, this.fs, this.monitors));
            this.log.info("Store files need to be recovered starting from: %d", new Object[]{lastFlushedTxId});
            CatchupResult catchupResult = this.pullTransactions(from, expectedStoreId, destDir, lastFlushedTxId, true);
            if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                throw new StreamingTransactionsFailedException("Failed to pull transactions: " + (Object)((Object)catchupResult));
            }
        }
        catch (IOException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CatchupResult pullTransactions(MemberId from, StoreId expectedStoreId, File storeDir, long fromTxId, boolean asPartOfStoreCopy) throws IOException, StoreCopyFailedException {
        try (TransactionLogCatchUpWriter writer = this.transactionLogFactory.create(storeDir, this.fs, this.pageCache, this.logProvider, fromTxId, asPartOfStoreCopy);){
            CatchupResult lastStatus;
            this.log.info("Pulling transactions from: %d", new Object[]{fromTxId});
            long previousTxId = fromTxId - 1L;
            do {
                TxPullRequestResult result = this.txPullClient.pullTransactions(from, expectedStoreId, previousTxId, writer);
                lastStatus = result.catchupResult();
                previousTxId = result.lastTxId();
            } while (lastStatus == CatchupResult.SUCCESS_END_OF_BATCH);
            CatchupResult catchupResult = lastStatus;
            return catchupResult;
        }
        catch (CatchUpClientException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    public StoreId getStoreIdOf(MemberId from) throws StoreIdDownloadFailedException {
        return this.storeCopyClient.fetchStoreId(from);
    }
}

