/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;

public class StoreFiles {
    private static final FilenameFilter STORE_FILE_FILTER = (dir, name) -> !name.startsWith("metrics") && !name.startsWith("temp-copy") && !name.startsWith("raft-messages.") && !name.startsWith("debug.") && !name.startsWith("cluster-state") && !name.startsWith("store_lock");
    private FileSystemAbstraction fs;

    public StoreFiles(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    public void delete(File storeDir) throws IOException {
        for (File file : this.fs.listFiles(storeDir, STORE_FILE_FILTER)) {
            this.fs.deleteRecursively(file);
        }
    }

    void moveTo(File source, File target) throws IOException {
        for (File candidate : this.fs.listFiles(source, STORE_FILE_FILTER)) {
            this.fs.moveToDirectory(candidate, target);
        }
    }
}

