/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;

public class TemporaryStoreDirectory
implements AutoCloseable {
    private static final String TEMP_COPY_DIRECTORY_NAME = "temp-copy";
    private final FileSystemAbstraction fs;
    private final File tempStoreDir;

    public TemporaryStoreDirectory(FileSystemAbstraction fs, File parent) throws IOException {
        this.fs = fs;
        this.tempStoreDir = new File(parent, TEMP_COPY_DIRECTORY_NAME);
        this.cleanDirectory();
    }

    private void cleanDirectory() throws IOException {
        if (!this.fs.mkdir(this.tempStoreDir)) {
            this.fs.deleteRecursively(this.tempStoreDir);
        }
    }

    public File storeDir() {
        return this.tempStoreDir;
    }

    @Override
    public void close() throws IOException {
        this.cleanDirectory();
    }
}

