/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.tx.PullRequestMonitor;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class BatchingTxApplier
extends LifecycleAdapter {
    private final int maxBatchSize;
    private final Supplier<TransactionIdStore> txIdStoreSupplier;
    private final Supplier<TransactionCommitProcess> commitProcessSupplier;
    private final PullRequestMonitor monitor;
    private final Log log;
    private TransactionQueue txQueue;
    private TransactionCommitProcess commitProcess;
    private volatile long lastQueuedTxId;
    private volatile boolean stopped;

    public BatchingTxApplier(int maxBatchSize, Supplier<TransactionIdStore> txIdStoreSupplier, Supplier<TransactionCommitProcess> commitProcessSupplier, Monitors monitors, LogProvider logProvider) {
        this.maxBatchSize = maxBatchSize;
        this.txIdStoreSupplier = txIdStoreSupplier;
        this.commitProcessSupplier = commitProcessSupplier;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.monitor = (PullRequestMonitor)monitors.newMonitor(PullRequestMonitor.class, new String[0]);
    }

    public void start() {
        this.stopped = false;
        this.refreshFromNewStore();
        this.txQueue = new TransactionQueue(this.maxBatchSize, (first, last) -> this.commitProcess.commit(first, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL));
    }

    public void stop() {
        this.stopped = true;
    }

    void refreshFromNewStore() {
        assert (this.txQueue == null || this.txQueue.isEmpty());
        this.lastQueuedTxId = this.txIdStoreSupplier.get().getLastCommittedTransactionId();
        this.commitProcess = this.commitProcessSupplier.get();
    }

    public void queue(CommittedTransactionRepresentation tx) throws Exception {
        long expectedTxId;
        long receivedTxId = tx.getCommitEntry().getTxId();
        if (receivedTxId != (expectedTxId = this.lastQueuedTxId + 1L)) {
            this.log.warn("Out of order transaction. Received: %d Expected: %d", new Object[]{receivedTxId, expectedTxId});
            return;
        }
        this.txQueue.queue(new TransactionToApply(tx.getTransactionRepresentation(), receivedTxId));
        if (!this.stopped) {
            this.lastQueuedTxId = receivedTxId;
            this.monitor.txPullResponse(receivedTxId);
        }
    }

    void applyBatch() throws Exception {
        this.txQueue.empty();
    }

    long lastQueuedTxId() {
        return this.lastQueuedTxId;
    }
}

