/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.storeid.StoreIdMarshal;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ReadableChannel;

public class TxPullResponseDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        NetworkReadableClosableChannelNetty4 logChannel = new NetworkReadableClosableChannelNetty4(msg);
        StoreId storeId = (StoreId)StoreIdMarshal.INSTANCE.unmarshal((ReadableChannel)logChannel);
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory());
        PhysicalTransactionCursor transactionCursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)logChannel, (LogEntryReader)reader);
        transactionCursor.next();
        CommittedTransactionRepresentation tx = transactionCursor.get();
        if (tx != null) {
            out.add(new TxPullResponse(storeId, tx));
        }
    }
}

