/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings for Causal Clustering")
public class CausalClusteringSettings {
    @Description(value="Time out for a new member to catch up")
    public static final Setting<Long> join_catch_up_timeout = Settings.setting((String)"causal_clustering.join_catch_up_timeout", (Function)Settings.DURATION, (String)"10m");
    @Description(value="The time limit within which a new leader election will occur if no messages are received.")
    public static final Setting<Long> leader_election_timeout = Settings.setting((String)"causal_clustering.leader_election_timeout", (Function)Settings.DURATION, (String)"7s");
    @Description(value="The maximum batch size when catching up (in unit of entries)")
    public static final Setting<Integer> catchup_batch_size = Settings.setting((String)"causal_clustering.catchup_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="The maximum lag allowed before log shipping pauses (in unit of entries)")
    public static final Setting<Integer> log_shipping_max_lag = Settings.setting((String)"causal_clustering.log_shipping_max_lag", (Function)Settings.INTEGER, (String)"256");
    @Description(value="Size of the RAFT in queue")
    @Internal
    public static final Setting<Integer> raft_in_queue_size = Settings.setting((String)"causal_clustering.raft_in_queue_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Largest batch processed by RAFT")
    @Internal
    public static final Setting<Integer> raft_in_queue_max_batch = Settings.setting((String)"causal_clustering.raft_in_queue_max_batch", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Expected number of Core machines in the cluster")
    public static final Setting<Integer> expected_core_cluster_size = Settings.setting((String)"causal_clustering.expected_core_cluster_size", (Function)Settings.INTEGER, (String)"3");
    @Description(value="Network interface and port for the transaction shipping server to listen on.")
    public static final Setting<ListenSocketAddress> transaction_listen_address = Settings.listenAddress((String)"causal_clustering.transaction_listen_address", (int)6000);
    @Description(value="Hostname/IP address and port for the transaction shipping server to listen on.")
    public static final Setting<AdvertisedSocketAddress> transaction_advertised_address = Settings.advertisedAddress((String)"causal_clustering.transaction_advertised_address", transaction_listen_address);
    @Description(value="Network interface and port for the RAFT server to listen on.")
    public static final Setting<ListenSocketAddress> raft_listen_address = Settings.listenAddress((String)"causal_clustering.raft_listen_address", (int)7000);
    @Description(value="Hostname/IP address and port for the RAFT server to listen on.")
    public static final Setting<AdvertisedSocketAddress> raft_advertised_address = Settings.advertisedAddress((String)"causal_clustering.raft_advertised_address", raft_listen_address);
    @Description(value="Host and port to bind the cluster member discovery management communication.")
    public static final Setting<ListenSocketAddress> discovery_listen_address = Settings.listenAddress((String)"causal_clustering.discovery_listen_address", (int)5000);
    @Description(value="Advertised cluster member discovery management communication.")
    public static final Setting<AdvertisedSocketAddress> discovery_advertised_address = Settings.advertisedAddress((String)"causal_clustering.discovery_advertised_address", discovery_listen_address);
    @Description(value="A comma-separated list of other members of the cluster to join.")
    public static final Setting<List<AdvertisedSocketAddress>> initial_discovery_members = Settings.setting((String)"causal_clustering.initial_discovery_members", (Function)Settings.list((String)",", (Function)Settings.ADVERTISED_SOCKET_ADDRESS), (String)Settings.MANDATORY);
    @Description(value="Prevents the network middleware from dumping its own logs. Defaults to true.")
    public static final Setting<Boolean> disable_middleware_logging = Settings.setting((String)"causal_clustering.disable_middleware_logging", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="The maximum file size before the storage file is rotated (in unit of entries)")
    public static final Setting<Integer> last_flushed_state_size = Settings.setting((String)"causal_clustering.last_applied_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the ID allocation file is rotated (in unit of entries)")
    public static final Setting<Integer> id_alloc_state_size = Settings.setting((String)"causal_clustering.id_alloc_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the membership state file is rotated (in unit of entries)")
    public static final Setting<Integer> raft_membership_state_size = Settings.setting((String)"causal_clustering.raft_membership_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the vote state file is rotated (in unit of entries)")
    public static final Setting<Integer> vote_state_size = Settings.setting((String)"causal_clustering.raft_vote_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the term state file is rotated (in unit of entries)")
    public static final Setting<Integer> term_state_size = Settings.setting((String)"causal_clustering.raft_term_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the global session tracker state file is rotated (in unit of entries)")
    public static final Setting<Integer> global_session_tracker_state_size = Settings.setting((String)"causal_clustering.global_session_tracker_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the replicated lock token state file is rotated (in unit of entries)")
    public static final Setting<Integer> replicated_lock_token_state_size = Settings.setting((String)"causal_clustering.replicated_lock_token_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The number of messages waiting to be sent to other servers in the cluster")
    public static final Setting<Integer> outgoing_queue_size = Settings.setting((String)"causal_clustering.outgoing_queue_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="The number of operations to be processed before the state machines flush to disk")
    public static final Setting<Integer> state_machine_flush_window_size = Settings.setting((String)"causal_clustering.state_machine_flush_window_size", (Function)Settings.INTEGER, (String)"4096");
    @Description(value="The maximum number of operations to be batched during applications of operations in the state machines")
    public static final Setting<Integer> state_machine_apply_max_batch_size = Settings.setting((String)"causal_clustering.state_machine_apply_max_batch_size", (Function)Settings.INTEGER, (String)"16");
    @Description(value="RAFT log pruning strategy")
    public static final Setting<String> raft_log_pruning_strategy = Settings.setting((String)"causal_clustering.raft_log_prune_strategy", (Function)Settings.STRING, (String)"1g size");
    @Description(value="RAFT log implementation")
    public static final Setting<String> raft_log_implementation = Settings.setting((String)"causal_clustering.raft_log_implementation", (Function)Settings.STRING, (String)"SEGMENTED");
    @Description(value="RAFT log rotation size")
    public static final Setting<Long> raft_log_rotation_size = Settings.setting((String)"causal_clustering.raft_log_rotation_size", (Function)Settings.BYTES, (String)"250M", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(1024L))});
    @Description(value="RAFT log reader pool size")
    public static final Setting<Integer> raft_log_reader_pool_size = Settings.setting((String)"causal_clustering.raft_log_reader_pool_size", (Function)Settings.INTEGER, (String)"8");
    @Description(value="RAFT log pruning frequency")
    public static final Setting<Long> raft_log_pruning_frequency = Settings.setting((String)"causal_clustering.raft_log_pruning_frequency", (Function)Settings.DURATION, (String)"10m");
    @Description(value="Enable or disable the dump of all network messages pertaining to the RAFT protocol")
    public static final Setting<Boolean> raft_messages_log_enable = Settings.setting((String)"causal_clustering.raft_messages_log_enable", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Interval of pulling updates from cores.")
    public static final Setting<Long> pull_interval = Settings.setting((String)"causal_clustering.pull_interval", (Function)Settings.DURATION, (String)"1s");
    @Description(value="The catch up protocol times out if the given duration elapses with not network activity. Every message received by the client from the server extends the time out duration.")
    @Internal
    public static final Setting<Long> catch_up_client_inactivity_timeout = Settings.setting((String)"causal_clustering.catch_up_client_inactivity_timeout", (Function)Settings.DURATION, (String)"5s");
    @Description(value="Throttle limit for logging unknown cluster member address")
    public static final Setting<Long> unknown_address_logging_throttle = Settings.setting((String)"causal_clustering.unknown_address_logging_throttle", (Function)Settings.DURATION, (String)"10000ms");
    @Description(value="Maximum number of transactions to send in response to a TX pull request.")
    @Internal
    public static final Setting<Integer> tx_pull_batch_size = Settings.setting((String)"causal_clustering.tx_pull_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Maximum transaction batch size for read replicas when applying transactions pulled from core servers.")
    @Internal
    public static Setting<Integer> read_replica_transaction_applier_batch_size = Settings.setting((String)"causal_clustering.read_replica_transaction_applier_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Time To Live before read replica is considered unavailable")
    public static final Setting<Long> read_replica_time_to_live = Settings.setting((String)"causal_clustering.read_replica_time_to_live", (Function)Settings.DURATION, (String)"1m", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(60000L))});
    @Description(value="Read replica 'call home' frequency")
    public static final Setting<Long> read_replica_refresh_rate = Settings.setting((String)"causal_clustering.read_replica_refresh_rate", (Function)Settings.DURATION, (String)"5s", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(5000L))});
    @Description(value="How long drivers should cache the data from the `dbms.cluster.routing.getServers()` procedure.")
    public static final Setting<Long> cluster_routing_ttl = Settings.setting((String)"causal_clustering.cluster_routing_ttl", (Function)Settings.DURATION, (String)"5m", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(1000L))});
    @Description(value="Configure if the `dbms.cluster.routing.getServers()` procedure should include followers as read endpoints or return only read replicas. If there are no read replicas in the cluster, followers are returned as read end points regardless the value of this setting.")
    public static final Setting<Boolean> cluster_allow_reads_on_followers = Settings.setting((String)"causal_clustering.cluster_allow_reads_on_followers", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_id_allocation_size = Settings.setting((String)"causal_clustering.node_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_id_allocation_size = Settings.setting((String)"causal_clustering.property_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of STRING_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> string_block_id_allocation_size = Settings.setting((String)"causal_clustering.string_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of ARRAY_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> array_block_id_allocation_size = Settings.setting((String)"causal_clustering.array_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NEOSTORE_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> neostore_block_id_allocation_size = Settings.setting((String)"causal_clustering.neostore_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of SCHEMA IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> schema_id_allocation_size = Settings.setting((String)"causal_clustering.schema_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE_LABELS IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_labels_id_allocation_size = Settings.setting((String)"causal_clustering.node_labels_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_GROUP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_group_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_group_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="Time between scanning the cluster to refresh current server's view of topology")
    public static final Setting<Long> cluster_topology_refresh = Settings.setting((String)"causal_clustering.cluster_topology_refresh", (Function)Settings.DURATION, (String)"1m", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(1000L))});
}

