/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.util.CustomIOConfigValidator;

public class CoreGraphDatabase
extends GraphDatabaseFacade {
    public static final String CUSTOM_IO_EXCEPTION_MESSAGE = "Core cluster mode is not allowed with custom IO integrations";

    public CoreGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this(storeDir, params, dependencies, new HazelcastDiscoveryServiceFactory());
    }

    public CoreGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, DiscoveryServiceFactory discoveryServiceFactory) {
        CustomIOConfigValidator.assertCustomIOConfigNotUsed((Config)new Config(params), (String)CUSTOM_IO_EXCEPTION_MESSAGE);
        Function<PlatformModule, EditionModule> factory = platformModule -> new EnterpriseCoreEditionModule((PlatformModule)platformModule, discoveryServiceFactory);
        new GraphDatabaseFacadeFactory(DatabaseInfo.CORE, factory).initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    public MemberId id() {
        return ((RaftMachine)this.getDependencyResolver().resolveDependency(RaftMachine.class)).identity();
    }

    public Role getRole() {
        return ((RaftMachine)this.getDependencyResolver().resolveDependency(RaftMachine.class)).currentRole();
    }
}

