/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.VersionDecoder;
import org.neo4j.causalclustering.VersionPrepender;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.handlers.ExceptionLoggingHandler;
import org.neo4j.causalclustering.handlers.ExceptionMonitoringHandler;
import org.neo4j.causalclustering.handlers.ExceptionSwallowingHandler;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.RaftMessageDecoder;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftServer
extends LifecycleAdapter
implements Inbound<RaftMessages.ClusterIdAwareMessage> {
    private static final Setting<ListenSocketAddress> setting = CausalClusteringSettings.raft_listen_address;
    private final ChannelMarshal<ReplicatedContent> marshal;
    private final ListenSocketAddress listenAddress;
    private final LogProvider logProvider;
    private final Log log;
    private final Log userLog;
    private final Monitors monitors;
    private Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> messageHandler;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private final NamedThreadFactory threadFactory = new NamedThreadFactory("raft-server");

    public RaftServer(ChannelMarshal<ReplicatedContent> marshal, Config config, LogProvider logProvider, LogProvider userLogProvider, Monitors monitors) {
        this.marshal = marshal;
        this.listenAddress = (ListenSocketAddress)config.get(setting);
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.monitors = monitors;
    }

    public synchronized void start() throws Throwable {
        this.startNettyServer();
    }

    public synchronized void stop() throws Throwable {
        this.log.info("RaftServer stopping and unbinding from " + this.listenAddress);
        try {
            this.channel.close().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.warn("Interrupted while closing channel.");
        }
        if (this.workerGroup.shutdownGracefully(2L, 5L, TimeUnit.SECONDS).awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
            this.log.warn("Worker group not shutdown within 10 seconds.");
        }
    }

    private void startNettyServer() {
        block2: {
            this.workerGroup = new NioEventLoopGroup(0, (ThreadFactory)this.threadFactory);
            this.log.info("Starting server at: " + this.listenAddress);
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress((SocketAddress)this.listenAddress.socketAddress())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)});
                    pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(4)});
                    pipeline.addLast(new ChannelHandler[]{new VersionDecoder(RaftServer.this.logProvider)});
                    pipeline.addLast(new ChannelHandler[]{new VersionPrepender()});
                    pipeline.addLast(new ChannelHandler[]{new RaftMessageDecoder(RaftServer.this.marshal)});
                    pipeline.addLast(new ChannelHandler[]{new RaftMessageHandler()});
                    pipeline.addLast(new ChannelHandler[]{new ExceptionLoggingHandler(RaftServer.this.log)});
                    pipeline.addLast(new ChannelHandler[]{new ExceptionMonitoringHandler((ExceptionMonitoringHandler.Monitor)RaftServer.this.monitors.newMonitor(ExceptionMonitoringHandler.Monitor.class, RaftServer.class, new String[0]))});
                    pipeline.addLast(new ChannelHandler[]{new ExceptionSwallowingHandler()});
                }
            });
            try {
                this.channel = bootstrap.bind().syncUninterruptibly().channel();
            }
            catch (Exception e) {
                if (!(e instanceof BindException)) break block2;
                this.userLog.error("Address is already bound for setting: " + setting + " with value: " + this.listenAddress);
                this.log.error("Address is already bound for setting: " + setting + " with value: " + this.listenAddress, (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void registerHandler(Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> handler) {
        this.messageHandler = handler;
    }

    private class RaftMessageHandler
    extends SimpleChannelInboundHandler<RaftMessages.ClusterIdAwareMessage> {
        private RaftMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, RaftMessages.ClusterIdAwareMessage clusterIdAwareMessage) throws Exception {
            try {
                RaftServer.this.messageHandler.handle(clusterIdAwareMessage);
            }
            catch (Exception e) {
                RaftServer.this.log.error(String.format("Failed to process message %s", clusterIdAwareMessage), (Throwable)e);
            }
        }
    }
}

