/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class EntryRecord {
    private final long logIndex;
    private final RaftLogEntry logEntry;

    public EntryRecord(long logIndex, RaftLogEntry logEntry) {
        this.logIndex = logIndex;
        this.logEntry = logEntry;
    }

    public RaftLogEntry logEntry() {
        return this.logEntry;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public static EntryRecord read(ReadableChannel channel, ChannelMarshal<ReplicatedContent> contentMarshal) throws IOException, EndOfStreamException {
        try {
            long appendIndex = channel.getLong();
            long term = channel.getLong();
            ReplicatedContent content = contentMarshal.unmarshal(channel);
            return new EntryRecord(appendIndex, new RaftLogEntry(term, content));
        }
        catch (ReadPastEndException e) {
            throw new EndOfStreamException(e);
        }
    }

    public static void write(WritableChannel channel, ChannelMarshal<ReplicatedContent> contentMarshal, long logIndex, long term, ReplicatedContent content) throws IOException {
        channel.putLong(logIndex);
        channel.putLong(term);
        contentMarshal.marshal(content, channel);
    }

    public String toString() {
        return String.format("%d: %s", this.logIndex, this.logEntry);
    }
}

