/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.DamagedLogStorageException;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.EntryCursor;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.RecoveryProtocol;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLogPruner;
import org.neo4j.causalclustering.core.consensus.log.segmented.State;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class SegmentedRaftLog
extends LifecycleAdapter
implements RaftLog {
    private final int READER_POOL_MAX_AGE = 1;
    private final FileSystemAbstraction fileSystem;
    private final File directory;
    private final long rotateAtSize;
    private final ChannelMarshal<ReplicatedContent> contentMarshal;
    private final FileNames fileNames;
    private final JobScheduler scheduler;
    private final Log log;
    private boolean needsRecovery;
    private final LogProvider logProvider;
    private final SegmentedRaftLogPruner pruner;
    private State state;
    private final ReaderPool readerPool;
    private JobScheduler.JobHandle readerPoolPruner;

    public SegmentedRaftLog(FileSystemAbstraction fileSystem, File directory, long rotateAtSize, ChannelMarshal<ReplicatedContent> contentMarshal, LogProvider logProvider, int readerPoolSize, Clock clock, JobScheduler scheduler, CoreLogPruningStrategy pruningStrategy) {
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.rotateAtSize = rotateAtSize;
        this.contentMarshal = contentMarshal;
        this.logProvider = logProvider;
        this.scheduler = scheduler;
        this.fileNames = new FileNames(directory);
        this.readerPool = new ReaderPool(readerPoolSize, logProvider, this.fileNames, fileSystem, clock);
        this.pruner = new SegmentedRaftLogPruner(pruningStrategy);
        this.log = logProvider.getLog(this.getClass());
    }

    public synchronized void start() throws IOException, DamagedLogStorageException, DisposedException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Could not create: " + this.directory);
        }
        this.state = new RecoveryProtocol(this.fileSystem, this.fileNames, this.readerPool, this.contentMarshal, this.logProvider).run();
        this.log.info("log started with recovered state %s", new Object[]{this.state});
        this.readerPoolPruner = this.scheduler.scheduleRecurring(new JobScheduler.Group("reader-pool-pruner", JobScheduler.SchedulingStrategy.POOLED), () -> this.readerPool.prune(1L, TimeUnit.MINUTES), 1L, 1L, TimeUnit.MINUTES);
    }

    public synchronized void stop() throws Throwable {
        this.readerPoolPruner.cancel(false);
        this.readerPool.close();
        this.state.segments.close();
    }

    @Override
    public synchronized long append(RaftLogEntry ... entries) throws IOException {
        this.ensureOk();
        try {
            for (RaftLogEntry entry : entries) {
                ++this.state.appendIndex;
                this.state.terms.append(this.state.appendIndex, entry.term());
                this.state.segments.last().write(this.state.appendIndex, entry);
            }
            this.state.segments.last().flush();
        }
        catch (Throwable e) {
            this.needsRecovery = true;
            throw e;
        }
        if (this.state.segments.last().position() >= this.rotateAtSize) {
            this.rotateSegment(this.state.appendIndex, this.state.appendIndex, this.state.terms.latest());
        }
        return this.state.appendIndex;
    }

    private void ensureOk() {
        if (this.needsRecovery) {
            throw new IllegalStateException("Raft log requires recovery");
        }
    }

    @Override
    public synchronized void truncate(long fromIndex) throws IOException {
        if (this.state.appendIndex < fromIndex) {
            throw new IllegalArgumentException("Cannot truncate at index " + fromIndex + " when append index is " + this.state.appendIndex);
        }
        long newAppendIndex = fromIndex - 1L;
        long newTerm = this.readEntryTerm(newAppendIndex);
        this.truncateSegment(this.state.appendIndex, newAppendIndex, newTerm);
        this.state.appendIndex = newAppendIndex;
        this.state.terms.truncate(fromIndex);
    }

    private void rotateSegment(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        this.state.segments.last().closeWriter();
        this.state.segments.rotate(prevFileLastIndex, prevIndex, prevTerm);
    }

    private void truncateSegment(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        this.state.segments.last().closeWriter();
        this.state.segments.truncate(prevFileLastIndex, prevIndex, prevTerm);
    }

    private void skipSegment(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        this.state.segments.last().closeWriter();
        this.state.segments.skip(prevFileLastIndex, prevIndex, prevTerm);
    }

    @Override
    public long appendIndex() {
        return this.state.appendIndex;
    }

    @Override
    public long prevIndex() {
        return this.state.prevIndex;
    }

    @Override
    public RaftLogCursor getEntryCursor(long fromIndex) throws IOException {
        EntryCursor inner = new EntryCursor(this.state.segments, fromIndex);
        return new SegmentedRaftLogCursor(fromIndex, inner);
    }

    @Override
    public synchronized long skip(long newIndex, long newTerm) throws IOException {
        this.log.info("Skipping from {index: %d, term: %d} to {index: %d, term: %d}", new Object[]{this.state.appendIndex, this.state.terms.latest(), newIndex, newTerm});
        if (this.state.appendIndex < newIndex) {
            this.skipSegment(this.state.appendIndex, newIndex, newTerm);
            this.state.terms.skip(newIndex, newTerm);
            this.state.prevIndex = newIndex;
            this.state.prevTerm = newTerm;
            this.state.appendIndex = newIndex;
        }
        return this.state.appendIndex;
    }

    private RaftLogEntry readLogEntry(long logIndex) throws IOException {
        try (EntryCursor cursor = new EntryCursor(this.state.segments, logIndex);){
            RaftLogEntry raftLogEntry = cursor.next() ? ((EntryRecord)cursor.get()).logEntry() : null;
            return raftLogEntry;
        }
    }

    @Override
    public long readEntryTerm(long logIndex) throws IOException {
        if (logIndex > this.state.appendIndex) {
            return -1L;
        }
        long term = this.state.terms.get(logIndex);
        if (term == -1L && logIndex >= this.state.prevIndex) {
            RaftLogEntry entry = this.readLogEntry(logIndex);
            term = entry != null ? entry.term() : -1L;
        }
        return term;
    }

    @Override
    public long prune(long safeIndex) throws IOException {
        long pruneIndex = this.pruner.getIndexToPruneFrom(safeIndex, this.state.segments);
        SegmentFile oldestNotDisposed = this.state.segments.prune(pruneIndex);
        long newPrevIndex = oldestNotDisposed.header().prevIndex();
        long newPrevTerm = oldestNotDisposed.header().prevTerm();
        if (newPrevIndex > this.state.prevIndex) {
            this.state.prevIndex = newPrevIndex;
        }
        if (newPrevTerm > this.state.prevTerm) {
            this.state.prevTerm = newPrevTerm;
        }
        this.state.terms.prune(this.state.prevIndex);
        return this.state.prevIndex;
    }
}

