/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.Arrays;

public class Terms {
    private int size;
    private long[] indexes;
    private long[] terms;
    private long min;
    private long max;

    Terms(long prevIndex, long prevTerm) {
        this.skip(prevIndex, prevTerm);
    }

    synchronized void append(long index, long term) {
        if (index != this.max + 1L) {
            throw new IllegalStateException("Must append in order");
        }
        if (term < this.terms[this.size - 1]) {
            throw new IllegalStateException("Non-monotonic term");
        }
        this.max = index;
        if (term != this.terms[this.size - 1]) {
            this.setSize(this.size + 1);
            this.indexes[this.size - 1] = index;
            this.terms[this.size - 1] = term;
        }
    }

    private void setSize(int newSize) {
        if (newSize != this.size) {
            this.size = newSize;
            this.indexes = Arrays.copyOf(this.indexes, this.size);
            this.terms = Arrays.copyOf(this.terms, this.size);
        }
    }

    synchronized void truncate(long fromIndex) {
        int newSize;
        this.max = fromIndex - 1L;
        for (newSize = this.size; newSize > 0 && this.indexes[newSize - 1] >= fromIndex; --newSize) {
        }
        this.setSize(newSize);
    }

    synchronized void prune(long upToIndex) {
        this.min = Math.max(upToIndex, this.min);
        int lastToPrune = this.findRangeContaining(this.min) - 1;
        if (lastToPrune < 0) {
            return;
        }
        this.size = this.indexes.length - 1 - lastToPrune;
        this.indexes = Arrays.copyOfRange(this.indexes, lastToPrune + 1, this.indexes.length);
        this.terms = Arrays.copyOfRange(this.terms, lastToPrune + 1, this.terms.length);
    }

    private int findRangeContaining(long index) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] > index) {
                return i - 1;
            }
            if (this.indexes[i] != index) continue;
            return i;
        }
        return -1;
    }

    synchronized void skip(long prevIndex, long prevTerm) {
        this.min = this.max = prevIndex;
        this.size = 1;
        this.indexes = new long[this.size];
        this.terms = new long[this.size];
        this.indexes[0] = prevIndex;
        this.terms[0] = prevTerm;
    }

    synchronized long get(long logIndex) {
        if (logIndex == -1L || logIndex < this.min || logIndex > this.max) {
            return -1L;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (logIndex < this.indexes[i]) continue;
            return this.terms[i];
        }
        throw new RuntimeException("Should be possible to find index >= min");
    }

    synchronized long latest() {
        return this.terms[this.size - 1];
    }
}

