/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.membership.RaftGroup;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembership;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipChanger;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.replication.SendToMyself;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftMembershipManager
extends LifecycleAdapter
implements RaftMembership,
RaftLogCommand.Handler {
    private RaftMembershipChanger membershipChanger;
    private Set<MemberId> targetMembers = null;
    private final SendToMyself sendToMyself;
    private final RaftGroup.Builder<MemberId> memberSetBuilder;
    private final ReadableRaftLog raftLog;
    private final Log log;
    private final StateStorage<RaftMembershipState> storage;
    private LongSupplier recoverFromIndexSupplier;
    private RaftMembershipState state;
    private final int expectedClusterSize;
    private volatile Set<MemberId> votingMembers = Collections.unmodifiableSet(new HashSet());
    private volatile Set<MemberId> replicationMembers = Collections.unmodifiableSet(new HashSet());
    private Set<RaftMembership.Listener> listeners = new HashSet<RaftMembership.Listener>();
    private Set<MemberId> additionalReplicationMembers = new HashSet<MemberId>();

    public RaftMembershipManager(SendToMyself sendToMyself, RaftGroup.Builder<MemberId> memberSetBuilder, ReadableRaftLog raftLog, LogProvider logProvider, int expectedClusterSize, long electionTimeout, Clock clock, long catchupTimeout, StateStorage<RaftMembershipState> membershipStorage) {
        this.sendToMyself = sendToMyself;
        this.memberSetBuilder = memberSetBuilder;
        this.raftLog = raftLog;
        this.expectedClusterSize = expectedClusterSize;
        this.storage = membershipStorage;
        this.log = logProvider.getLog(this.getClass());
        this.membershipChanger = new RaftMembershipChanger(raftLog, clock, electionTimeout, logProvider, catchupTimeout, this);
    }

    public void setRecoverFromIndexSupplier(LongSupplier recoverFromIndexSupplier) {
        this.recoverFromIndexSupplier = recoverFromIndexSupplier;
    }

    public void start() throws IOException {
        this.state = this.storage.getInitialState();
        long recoverFromIndex = this.recoverFromIndexSupplier.getAsLong();
        this.log.info("Membership state before recovery: " + (Object)((Object)this.state));
        this.log.info("Recovering from: " + recoverFromIndex + " to: " + this.raftLog.appendIndex());
        try (RaftLogCursor cursor = this.raftLog.getEntryCursor(recoverFromIndex);){
            while (cursor.next()) {
                this.append(cursor.index(), (RaftLogEntry)cursor.get());
            }
        }
        this.log.info("Membership state after recovery: " + (Object)((Object)this.state));
        this.updateMemberSets();
    }

    public void setTargetMembershipSet(Set<MemberId> targetMembers) {
        this.targetMembers = new HashSet<MemberId>(targetMembers);
        this.log.info("Target membership: " + targetMembers);
        this.membershipChanger.onTargetChanged(targetMembers);
        this.checkForStartCondition();
    }

    private Set<MemberId> missingMembers() {
        if (this.targetMembers == null || this.votingMembers() == null) {
            return Collections.emptySet();
        }
        HashSet<MemberId> missingMembers = new HashSet<MemberId>(this.targetMembers);
        missingMembers.removeAll(this.votingMembers());
        return missingMembers;
    }

    private void updateMemberSets() {
        this.votingMembers = Collections.unmodifiableSet(this.state.getLatest());
        HashSet<MemberId> newReplicationMembers = new HashSet<MemberId>(this.votingMembers);
        newReplicationMembers.addAll(this.additionalReplicationMembers);
        this.replicationMembers = Collections.unmodifiableSet(newReplicationMembers);
        this.listeners.forEach(RaftMembership.Listener::onMembershipChanged);
    }

    void addAdditionalReplicationMember(MemberId member) {
        this.additionalReplicationMembers.add(member);
        this.updateMemberSets();
    }

    void removeAdditionalReplicationMember(MemberId member) {
        this.additionalReplicationMembers.remove(member);
        this.updateMemberSets();
    }

    private boolean isSafeToRemoveMember() {
        return this.votingMembers() != null && this.votingMembers().size() > this.expectedClusterSize;
    }

    private Set<MemberId> superfluousMembers() {
        if (this.targetMembers == null || this.votingMembers() == null) {
            return Collections.emptySet();
        }
        HashSet<MemberId> superfluousMembers = new HashSet<MemberId>(this.votingMembers());
        superfluousMembers.removeAll(this.targetMembers);
        return superfluousMembers;
    }

    private void checkForStartCondition() {
        if (this.missingMembers().size() > 0) {
            this.membershipChanger.onMissingMember((MemberId)Iterables.first(this.missingMembers()));
        } else if (this.isSafeToRemoveMember() && this.superfluousMembers().size() > 0) {
            this.membershipChanger.onSuperfluousMember((MemberId)Iterables.first(this.superfluousMembers()));
        }
    }

    void doConsensus(Set<MemberId> newVotingMemberSet) {
        this.sendToMyself.replicate(this.memberSetBuilder.build(newVotingMemberSet));
    }

    void stateChanged() {
        this.checkForStartCondition();
    }

    public void onFollowerStateChange(FollowerStates<MemberId> followerStates) {
        this.membershipChanger.onFollowerStateChange(followerStates);
    }

    public void onRole(Role role) {
        this.membershipChanger.onRole(role);
    }

    @Override
    public Set<MemberId> votingMembers() {
        return this.votingMembers;
    }

    @Override
    public Set<MemberId> replicationMembers() {
        return this.replicationMembers;
    }

    @Override
    public void registerListener(RaftMembership.Listener listener) {
        this.listeners.add(listener);
    }

    boolean uncommittedMemberChangeInLog() {
        return this.state.uncommittedMemberChangeInLog();
    }

    public void processLog(long commitIndex, Collection<RaftLogCommand> logCommands) throws IOException {
        for (RaftLogCommand logCommand : logCommands) {
            logCommand.dispatch(this);
        }
        if (this.state.commit(commitIndex)) {
            this.membershipChanger.onRaftGroupCommitted();
            this.storage.persistStoreData(this.state);
            this.updateMemberSets();
        }
    }

    @Override
    public void append(long baseIndex, RaftLogEntry ... entries) throws IOException {
        for (RaftLogEntry entry : entries) {
            if (entry.content() instanceof RaftGroup) {
                RaftGroup raftGroup = (RaftGroup)entry.content();
                if (this.state.uncommittedMemberChangeInLog()) {
                    this.log.warn("Appending with uncommitted membership change in log");
                }
                if (this.state.append(baseIndex, new HashSet<MemberId>(raftGroup.getMembers()))) {
                    this.storage.persistStoreData(this.state);
                    this.updateMemberSets();
                } else {
                    this.log.warn("Appending member set was ignored. Current state: %s, Appended set: %s, Log index: %d%n", new Object[]{this.state, raftGroup, baseIndex});
                }
            }
            ++baseIndex;
        }
    }

    @Override
    public void truncate(long fromIndex) throws IOException {
        if (this.state.truncate(fromIndex)) {
            this.storage.persistStoreData(this.state);
            this.updateMemberSets();
        }
    }

    public MembershipEntry getCommitted() {
        return this.state.committed();
    }

    public void install(MembershipEntry committed) throws IOException {
        this.state = new RaftMembershipState(committed.logIndex(), committed, null);
        this.storage.persistStoreData(this.state);
        this.updateMemberSets();
    }
}

