/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.List;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.BatchAppendLogEntries;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.ShipCommand;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Follower;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.logging.Log;

class Appending {
    Appending() {
    }

    static void handleAppendEntriesRequest(ReadableRaftState state, Outcome outcome, RaftMessages.AppendEntries.Request request, Log log) throws IOException {
        int offset;
        if (request.leaderTerm() < state.term()) {
            RaftMessages.AppendEntries.Response appendResponse = new RaftMessages.AppendEntries.Response(state.myself(), state.term(), false, -1L, state.entryLog().appendIndex());
            outcome.addOutgoingMessage(new RaftMessages.Directed(request.from(), appendResponse));
            return;
        }
        outcome.renewElectionTimeout();
        outcome.setNextTerm(request.leaderTerm());
        outcome.setLeader(request.from());
        outcome.setLeaderCommit(request.leaderCommit());
        if (!Follower.logHistoryMatches(state, request.prevLogIndex(), request.prevLogTerm(), log)) {
            assert (request.prevLogIndex() > -1L && request.prevLogTerm() > -1L);
            RaftMessages.AppendEntries.Response appendResponse = new RaftMessages.AppendEntries.Response(state.myself(), request.leaderTerm(), false, -1L, state.entryLog().appendIndex());
            outcome.addOutgoingMessage(new RaftMessages.Directed(request.from(), appendResponse));
            return;
        }
        long baseIndex = request.prevLogIndex() + 1L;
        for (offset = 0; offset < request.entries().length; ++offset) {
            long logTerm = state.entryLog().readEntryTerm(baseIndex + (long)offset);
            if (baseIndex + (long)offset > state.entryLog().appendIndex()) break;
            if (baseIndex + (long)offset < state.entryLog().prevIndex() || logTerm == request.entries()[offset].term()) continue;
            if (baseIndex + (long)offset <= state.commitIndex()) {
                throw new IllegalStateException("Cannot truncate at index " + (baseIndex + (long)offset) + " when commit index is at " + state.commitIndex());
            }
            outcome.addLogCommand(new TruncateLogCommand(baseIndex + (long)offset));
            break;
        }
        if (offset < request.entries().length) {
            outcome.addLogCommand(new BatchAppendLogEntries(baseIndex, offset, request.entries()));
        }
        Follower.commitToLogOnUpdate(state, request.prevLogIndex() + (long)request.entries().length, request.leaderCommit(), outcome);
        long endMatchIndex = request.prevLogIndex() + (long)request.entries().length;
        RaftMessages.AppendEntries.Response appendResponse = new RaftMessages.AppendEntries.Response(state.myself(), request.leaderTerm(), true, endMatchIndex, endMatchIndex);
        outcome.addOutgoingMessage(new RaftMessages.Directed(request.from(), appendResponse));
    }

    static void appendNewEntry(ReadableRaftState ctx, Outcome outcome, ReplicatedContent content) throws IOException {
        long prevLogIndex = ctx.entryLog().appendIndex();
        long prevLogTerm = prevLogIndex == -1L ? -1L : (prevLogIndex > ctx.lastLogIndexBeforeWeBecameLeader() ? ctx.term() : ctx.entryLog().readEntryTerm(prevLogIndex));
        RaftLogEntry newLogEntry = new RaftLogEntry(ctx.term(), content);
        outcome.addShipCommand(new ShipCommand.NewEntries(prevLogIndex, prevLogTerm, new RaftLogEntry[]{newLogEntry}));
        outcome.addLogCommand(new AppendLogEntry(prevLogIndex + 1L, newLogEntry));
    }

    static void appendNewEntries(ReadableRaftState ctx, Outcome outcome, List<ReplicatedContent> contents) throws IOException {
        long prevLogIndex = ctx.entryLog().appendIndex();
        long prevLogTerm = prevLogIndex == -1L ? -1L : (prevLogIndex > ctx.lastLogIndexBeforeWeBecameLeader() ? ctx.term() : ctx.entryLog().readEntryTerm(prevLogIndex));
        RaftLogEntry[] raftLogEntries = (RaftLogEntry[])contents.stream().map(content -> new RaftLogEntry(ctx.term(), (ReplicatedContent)content)).toArray(RaftLogEntry[]::new);
        outcome.addShipCommand(new ShipCommand.NewEntries(prevLogIndex, prevLogTerm, raftLogEntries));
        outcome.addLogCommand(new BatchAppendLogEntries(prevLogIndex + 1L, 0, raftLogEntries));
    }
}

