/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DelayedRenewableTimeoutService
extends LifecycleAdapter
implements Runnable,
RenewableTimeoutService {
    private static final int TIMER_RESOLUTION = 1;
    private static final TimeUnit TIMER_RESOLUTION_UNIT = TimeUnit.MILLISECONDS;
    private final SortedSet<ScheduledRenewableTimeout> timeouts = new TreeSet<ScheduledRenewableTimeout>();
    private final Queue<ScheduledRenewableTimeout> pendingRenewals = new ConcurrentLinkedDeque<ScheduledRenewableTimeout>();
    private final Clock clock;
    private final Log log;
    private final Random random;
    private final Neo4jJobScheduler scheduler;
    private JobScheduler.JobHandle jobHandle;

    public DelayedRenewableTimeoutService(Clock clock, LogProvider logProvider) {
        this.clock = clock;
        this.log = logProvider.getLog(this.getClass());
        this.random = new Random(System.nanoTime());
        this.scheduler = new Neo4jJobScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenewableTimeoutService.RenewableTimeout create(RenewableTimeoutService.TimeoutName name, long delayInMillis, long randomRangeInMillis, RenewableTimeoutService.TimeoutHandler handler) {
        ScheduledRenewableTimeout timeout = new ScheduledRenewableTimeout(this.calcTimeoutTimestamp(delayInMillis, randomRangeInMillis), delayInMillis, randomRangeInMillis, handler, this);
        SortedSet<ScheduledRenewableTimeout> sortedSet = this.timeouts;
        synchronized (sortedSet) {
            this.timeouts.add(timeout);
        }
        return timeout;
    }

    private void renew(ScheduledRenewableTimeout timeout) {
        this.pendingRenewals.offer(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(ScheduledRenewableTimeout timeout) {
        SortedSet<ScheduledRenewableTimeout> sortedSet = this.timeouts;
        synchronized (sortedSet) {
            this.timeouts.remove(timeout);
        }
    }

    private long calcTimeoutTimestamp(long milliseconds, long randomRange) {
        int randomness = randomRange != 0L ? this.random.nextInt((int)randomRange) : 0;
        return this.clock.millis() + milliseconds + (long)randomness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        long now = this.clock.millis();
        LinkedList<ScheduledRenewableTimeout> triggered = new LinkedList<ScheduledRenewableTimeout>();
        SortedSet<ScheduledRenewableTimeout> sortedSet = this.timeouts;
        synchronized (sortedSet) {
            ScheduledRenewableTimeout timeout;
            ScheduledRenewableTimeout renew;
            while ((renew = this.pendingRenewals.poll()) != null) {
                this.timeouts.remove(renew);
                renew.setTimeoutTimestamp(this.calcTimeoutTimestamp(renew.timeoutLength, renew.randomRange));
                this.timeouts.add(renew);
            }
            Iterator iterator = this.timeouts.iterator();
            while (iterator.hasNext() && (timeout = (ScheduledRenewableTimeout)iterator.next()).shouldTrigger(now)) {
                triggered.add(timeout);
            }
        }
        for (ScheduledRenewableTimeout timeout : triggered) {
            try {
                timeout.trigger();
            }
            catch (Throwable e) {
                this.log.error("Exception triggering timeout handler", e);
            }
        }
        sortedSet = this.timeouts;
        synchronized (sortedSet) {
            this.timeouts.removeAll(triggered);
        }
    }

    public void init() {
        this.scheduler.init();
    }

    public void start() {
        this.jobHandle = this.scheduler.scheduleRecurring(new JobScheduler.Group("Scheduler", JobScheduler.SchedulingStrategy.POOLED), (Runnable)this, 1L, TIMER_RESOLUTION_UNIT);
    }

    public void stop() {
        this.jobHandle.cancel(false);
        this.scheduler.stop();
        this.scheduler.shutdown();
    }

    static class ScheduledRenewableTimeout
    implements RenewableTimeoutService.RenewableTimeout,
    Comparable<ScheduledRenewableTimeout> {
        private static final AtomicLong idGen = new AtomicLong();
        private final long id = idGen.getAndIncrement();
        private final long timeoutLength;
        private final long randomRange;
        private final RenewableTimeoutService.TimeoutHandler handler;
        private final DelayedRenewableTimeoutService timeouts;
        private long timeoutTimestampMillis;

        ScheduledRenewableTimeout(long timeoutTimestampMillis, long timeoutLength, long randomRange, RenewableTimeoutService.TimeoutHandler handler, DelayedRenewableTimeoutService timeouts) {
            this.timeoutTimestampMillis = timeoutTimestampMillis;
            this.timeoutLength = timeoutLength;
            this.randomRange = randomRange;
            this.handler = handler;
            this.timeouts = timeouts;
        }

        private void trigger() {
            this.handler.onTimeout(this);
        }

        private boolean shouldTrigger(long currentTime) {
            return currentTime >= this.timeoutTimestampMillis;
        }

        @Override
        public void renew() {
            this.timeouts.renew(this);
        }

        @Override
        public void cancel() {
            this.timeouts.cancel(this);
        }

        void setTimeoutTimestamp(long newTimestamp) {
            this.timeoutTimestampMillis = newTimestamp;
        }

        @Override
        public int compareTo(ScheduledRenewableTimeout renewableTimeout) {
            if (this.timeoutTimestampMillis == renewableTimeout.timeoutTimestampMillis) {
                return (int)(this.id - renewableTimeout.id);
            }
            return (int)(this.timeoutTimestampMillis - renewableTimeout.timeoutTimestampMillis);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScheduledRenewableTimeout timeout = (ScheduledRenewableTimeout)o;
            return this.id == timeout.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            return "Timeout{id=" + this.id + ", randomRange=" + this.randomRange + ", timeoutLength=" + this.timeoutLength + ", timeoutTimestampMillis=" + this.timeoutTimestampMillis + ", handler=" + this.handler + '}';
        }
    }
}

