/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class GlobalSessionTrackerState {
    private Map<MemberId, LocalSessionTracker> sessionTrackers = new HashMap<MemberId, LocalSessionTracker>();
    private long logIndex = -1L;

    public boolean validateOperation(GlobalSession globalSession, LocalOperationId localOperationId) {
        LocalSessionTracker existingSessionTracker = this.sessionTrackers.get(globalSession.owner());
        if (this.isNewSession(globalSession, existingSessionTracker)) {
            return this.isFirstOperation(localOperationId);
        }
        return existingSessionTracker.isValidOperation(localOperationId);
    }

    public void update(GlobalSession globalSession, LocalOperationId localOperationId, long logIndex) {
        LocalSessionTracker localSessionTracker = this.validateGlobalSessionAndGetLocalSessionTracker(globalSession);
        localSessionTracker.validateAndTrackOperation(localOperationId);
        this.logIndex = logIndex;
    }

    private boolean isNewSession(GlobalSession globalSession, LocalSessionTracker existingSessionTracker) {
        return existingSessionTracker == null || !existingSessionTracker.globalSessionId.equals(globalSession.sessionId());
    }

    private boolean isFirstOperation(LocalOperationId id) {
        return id.sequenceNumber() == 0L;
    }

    public long logIndex() {
        return this.logIndex;
    }

    private LocalSessionTracker validateGlobalSessionAndGetLocalSessionTracker(GlobalSession globalSession) {
        LocalSessionTracker localSessionTracker = this.sessionTrackers.get(globalSession.owner());
        if (localSessionTracker == null || !localSessionTracker.globalSessionId.equals(globalSession.sessionId())) {
            localSessionTracker = new LocalSessionTracker(globalSession.sessionId(), new HashMap<Long, Long>());
            this.sessionTrackers.put(globalSession.owner(), localSessionTracker);
        }
        return localSessionTracker;
    }

    public GlobalSessionTrackerState newInstance() {
        GlobalSessionTrackerState copy = new GlobalSessionTrackerState();
        copy.logIndex = this.logIndex;
        for (Map.Entry<MemberId, LocalSessionTracker> entry : this.sessionTrackers.entrySet()) {
            copy.sessionTrackers.put(entry.getKey(), entry.getValue().newInstance());
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSessionTrackerState that = (GlobalSessionTrackerState)o;
        return this.logIndex == that.logIndex && Objects.equals(this.sessionTrackers, that.sessionTrackers);
    }

    public int hashCode() {
        return Objects.hash(this.sessionTrackers, this.logIndex);
    }

    public String toString() {
        return String.format("GlobalSessionTrackerState{sessionTrackers=%s, logIndex=%d}", this.sessionTrackers, this.logIndex);
    }

    private static class LocalSessionTracker {
        final UUID globalSessionId;
        final Map<Long, Long> lastSequenceNumberPerSession;

        LocalSessionTracker(UUID globalSessionId, Map<Long, Long> lastSequenceNumberPerSession) {
            this.globalSessionId = globalSessionId;
            this.lastSequenceNumberPerSession = lastSequenceNumberPerSession;
        }

        boolean validateAndTrackOperation(LocalOperationId operationId) {
            if (!this.isValidOperation(operationId)) {
                return false;
            }
            this.lastSequenceNumberPerSession.put(operationId.localSessionId(), operationId.sequenceNumber());
            return true;
        }

        private boolean isValidOperation(LocalOperationId operationId) {
            Long lastSequenceNumber = this.lastSequenceNumberPerSession.get(operationId.localSessionId());
            return !(lastSequenceNumber == null ? operationId.sequenceNumber() != 0L : operationId.sequenceNumber() != lastSequenceNumber + 1L);
        }

        public LocalSessionTracker newInstance() {
            return new LocalSessionTracker(this.globalSessionId, new HashMap<Long, Long>(this.lastSequenceNumberPerSession));
        }

        public String toString() {
            return String.format("LocalSessionTracker{globalSessionId=%s, lastSequenceNumberPerSession=%s}", this.globalSessionId, this.lastSequenceNumberPerSession);
        }
    }

    public static class Marshal
    extends SafeStateMarshal<GlobalSessionTrackerState> {
        private final ChannelMarshal<MemberId> memberMarshal;

        public Marshal(ChannelMarshal<MemberId> marshal) {
            this.memberMarshal = marshal;
        }

        @Override
        public void marshal(GlobalSessionTrackerState target, WritableChannel channel) throws IOException {
            Map sessionTrackers = target.sessionTrackers;
            channel.putLong(target.logIndex);
            channel.putInt(sessionTrackers.size());
            for (Map.Entry entry : sessionTrackers.entrySet()) {
                this.memberMarshal.marshal((MemberId)entry.getKey(), channel);
                LocalSessionTracker localSessionTracker = (LocalSessionTracker)entry.getValue();
                UUID uuid = localSessionTracker.globalSessionId;
                channel.putLong(uuid.getMostSignificantBits());
                channel.putLong(uuid.getLeastSignificantBits());
                Map<Long, Long> map = localSessionTracker.lastSequenceNumberPerSession;
                channel.putInt(map.size());
                for (Map.Entry<Long, Long> sessionSequence : map.entrySet()) {
                    channel.putLong(sessionSequence.getKey().longValue());
                    channel.putLong(sessionSequence.getValue().longValue());
                }
            }
        }

        @Override
        public GlobalSessionTrackerState unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            long logIndex = channel.getLong();
            int sessionTrackerSize = channel.getInt();
            HashMap<MemberId, LocalSessionTracker> sessionTrackers = new HashMap<MemberId, LocalSessionTracker>();
            for (int i = 0; i < sessionTrackerSize; ++i) {
                MemberId member = this.memberMarshal.unmarshal(channel);
                if (member == null) {
                    throw new IllegalStateException("Null member");
                }
                long mostSigBits = channel.getLong();
                long leastSigBits = channel.getLong();
                UUID globalSessionId = new UUID(mostSigBits, leastSigBits);
                int localSessionTrackerSize = channel.getInt();
                HashMap<Long, Long> lastSequenceNumberPerSession = new HashMap<Long, Long>();
                for (int j = 0; j < localSessionTrackerSize; ++j) {
                    long localSessionId = channel.getLong();
                    long sequenceNumber = channel.getLong();
                    lastSequenceNumberPerSession.put(localSessionId, sequenceNumber);
                }
                LocalSessionTracker localSessionTracker = new LocalSessionTracker(globalSessionId, lastSequenceNumberPerSession);
                sessionTrackers.put(member, localSessionTracker);
            }
            GlobalSessionTrackerState result = new GlobalSessionTrackerState();
            result.sessionTrackers = sessionTrackers;
            result.logIndex = logIndex;
            return result;
        }

        @Override
        public GlobalSessionTrackerState startState() {
            return new GlobalSessionTrackerState();
        }

        @Override
        public long ordinal(GlobalSessionTrackerState state) {
            return state.logIndex();
        }
    }
}

