/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.server;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.causalclustering.ReplicationModule;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupServer;
import org.neo4j.causalclustering.catchup.CheckpointerSupplier;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.ContinuousJob;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.RaftServer;
import org.neo4j.causalclustering.core.consensus.log.pruning.PruningScheduler;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiterLifecycle;
import org.neo4j.causalclustering.core.server.BatchingMessageHandler;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.CoreStateApplier;
import org.neo4j.causalclustering.core.state.LongIndexMarshal;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachinesModule;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.LoggingInbound;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class CoreServerModule {
    public static final String CLUSTER_ID_NAME = "cluster-id";
    public static final String LAST_FLUSHED_NAME = "last-flushed";
    public final MembershipWaiterLifecycle membershipWaiterLifecycle;

    public CoreServerModule(IdentityModule identityModule, PlatformModule platformModule, ConsensusModule consensusModule, CoreStateMachinesModule coreStateMachinesModule, ReplicationModule replicationModule, File clusterStateDirectory, ClusteringModule clusteringModule, LocalDatabase localDatabase, MessageLogger<MemberId> messageLogger, Supplier<DatabaseHealth> dbHealthSupplier) {
        Dependencies dependencies = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LifeSupport life = platformModule.life;
        Monitors monitors = platformModule.monitors;
        JobScheduler jobScheduler = platformModule.jobScheduler;
        LogProvider logProvider = logging.getInternalLogProvider();
        LogProvider userLogProvider = logging.getUserLogProvider();
        Supplier databaseHealthSupplier = dependencies.provideDependency(DatabaseHealth.class);
        StateStorage lastFlushedStorage = (StateStorage)life.add(new DurableStateStorage<Long>(fileSystem, clusterStateDirectory, LAST_FLUSHED_NAME, new LongIndexMarshal(), (Integer)config.get(CausalClusteringSettings.last_flushed_state_size), logProvider));
        consensusModule.raftMembershipManager().setRecoverFromIndexSupplier(lastFlushedStorage::getInitialState);
        RaftServer raftServer = new RaftServer(new CoreReplicatedContentMarshal(), config, logProvider, userLogProvider, monitors);
        LoggingInbound<RaftMessages.ClusterIdAwareMessage> loggingRaftInbound = new LoggingInbound<RaftMessages.ClusterIdAwareMessage>(raftServer, messageLogger, identityModule.myself());
        long inactivityTimeoutMillis = (Long)config.get(CausalClusteringSettings.catch_up_client_inactivity_timeout);
        CatchUpClient catchUpClient = (CatchUpClient)life.add((Lifecycle)new CatchUpClient(clusteringModule.topologyService(), logProvider, Clocks.systemClock(), inactivityTimeoutMillis, monitors));
        StoreFetcher storeFetcher = new StoreFetcher(logProvider, fileSystem, platformModule.pageCache, new StoreCopyClient(catchUpClient, logProvider), new TxPullClient(catchUpClient, platformModule.monitors), new TransactionLogCatchUpFactory(), platformModule.monitors);
        CoreStateApplier coreStateApplier = new CoreStateApplier(logProvider);
        CopiedStoreRecovery copiedStoreRecovery = new CopiedStoreRecovery(config, platformModule.kernelExtensions.listFactories(), platformModule.pageCache);
        life.add((Lifecycle)copiedStoreRecovery);
        final LifeSupport servicesToStopOnStoreCopy = new LifeSupport();
        CoreStateDownloader downloader = new CoreStateDownloader(platformModule.fileSystem, localDatabase, (Lifecycle)servicesToStopOnStoreCopy, storeFetcher, catchUpClient, logProvider, copiedStoreRecovery);
        if (((Boolean)config.get(OnlineBackupSettings.online_backup_enabled)).booleanValue()) {
            platformModule.dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource dataSource) {
                    servicesToStopOnStoreCopy.add((Lifecycle)this.pickBackupExtension(dataSource));
                }

                public void unregistered(NeoStoreDataSource dataSource) {
                    servicesToStopOnStoreCopy.remove((Lifecycle)this.pickBackupExtension(dataSource));
                }

                private OnlineBackupKernelExtension pickBackupExtension(NeoStoreDataSource dataSource) {
                    return (OnlineBackupKernelExtension)dataSource.getDependencyResolver().resolveDependency(OnlineBackupKernelExtension.class);
                }
            });
        }
        CommandApplicationProcess commandApplicationProcess = new CommandApplicationProcess(coreStateMachinesModule.coreStateMachines, consensusModule.raftLog(), (Integer)config.get(CausalClusteringSettings.state_machine_apply_max_batch_size), (Integer)config.get(CausalClusteringSettings.state_machine_flush_window_size), databaseHealthSupplier, logProvider, replicationModule.getProgressTracker(), lastFlushedStorage, replicationModule.getSessionTracker(), coreStateApplier, consensusModule.inFlightMap(), platformModule.monitors);
        CoreState coreState = new CoreState(consensusModule.raftMachine(), localDatabase, clusteringModule.clusterIdentity(), logProvider, downloader, commandApplicationProcess);
        dependencies.satisfyDependency((Object)coreState);
        life.add((Lifecycle)new PruningScheduler(coreState, jobScheduler, (Long)config.get(CausalClusteringSettings.raft_log_pruning_frequency), logProvider));
        int queueSize = (Integer)config.get(CausalClusteringSettings.raft_in_queue_size);
        int maxBatch = (Integer)config.get(CausalClusteringSettings.raft_in_queue_max_batch);
        BatchingMessageHandler batchingMessageHandler = new BatchingMessageHandler(coreState, queueSize, maxBatch, logProvider);
        long electionTimeout = (Long)config.get(CausalClusteringSettings.leader_election_timeout);
        MembershipWaiter membershipWaiter = new MembershipWaiter(identityModule.myself(), jobScheduler, dbHealthSupplier, electionTimeout * 4L, logProvider);
        long joinCatchupTimeout = (Long)config.get(CausalClusteringSettings.join_catch_up_timeout);
        this.membershipWaiterLifecycle = new MembershipWaiterLifecycle(membershipWaiter, joinCatchupTimeout, consensusModule.raftMachine(), logProvider);
        loggingRaftInbound.registerHandler(batchingMessageHandler);
        CatchupServer catchupServer = new CatchupServer(logProvider, userLogProvider, localDatabase::storeId, platformModule.dependencies.provideDependency(TransactionIdStore.class), platformModule.dependencies.provideDependency(LogicalTransactionStore.class), localDatabase::dataSource, localDatabase::isAvailable, coreState, config, platformModule.monitors, new CheckpointerSupplier(platformModule.dependencies), fileSystem);
        servicesToStopOnStoreCopy.add((Lifecycle)catchupServer);
        life.add((Lifecycle)raftServer);
        life.add((Lifecycle)catchupServer);
        life.add((Lifecycle)batchingMessageHandler);
        life.add((Lifecycle)new ContinuousJob(jobScheduler, new JobScheduler.Group("raft-batch-handler", JobScheduler.SchedulingStrategy.NEW_THREAD), batchingMessageHandler, logProvider));
        life.add((Lifecycle)coreState);
    }
}

