/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.ClusterIdentity;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class ClusteringModule {
    private final CoreTopologyService topologyService;
    private final ClusterIdentity clusterIdentity;

    public ClusteringModule(DiscoveryServiceFactory discoveryServiceFactory, MemberId myself, PlatformModule platformModule, File clusterStateDirectory) {
        LifeSupport life = platformModule.life;
        Config config = platformModule.config;
        LogProvider logProvider = platformModule.logging.getInternalLogProvider();
        LogProvider userLogProvider = platformModule.logging.getUserLogProvider();
        Dependencies dependencies = platformModule.dependencies;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        this.topologyService = discoveryServiceFactory.coreTopologyService(config, myself, platformModule.jobScheduler, logProvider, userLogProvider);
        life.add((Lifecycle)this.topologyService);
        dependencies.satisfyDependency((Object)this.topologyService);
        SimpleFileStorage<ClusterId> clusterIdStorage = new SimpleFileStorage<ClusterId>(fileSystem, clusterStateDirectory, "cluster-id", new ClusterId.Marshal(), logProvider);
        CoreBootstrapper coreBootstrapper = new CoreBootstrapper(platformModule.storeDir, platformModule.pageCache, fileSystem, config, logProvider);
        this.clusterIdentity = new ClusterIdentity(clusterIdStorage, this.topologyService, logProvider, Clocks.systemClock(), (ThrowingAction<InterruptedException>)((ThrowingAction)() -> Thread.sleep(100L)), 300000L, coreBootstrapper);
    }

    public CoreTopologyService topologyService() {
        return this.topologyService;
    }

    public ClusterIdentity clusterIdentity() {
        return this.clusterIdentity;
    }
}

