/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.pruning.LogPruner;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.ClusterIdentity;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreState
implements Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage>,
LogPruner,
Lifecycle {
    private final RaftMachine raftMachine;
    private final LocalDatabase localDatabase;
    private final Log log;
    private final ClusterIdentity clusterIdentity;
    private final CoreStateDownloader downloader;
    private final CommandApplicationProcess applicationProcess;
    private boolean allowMessageHandling;

    public CoreState(RaftMachine raftMachine, LocalDatabase localDatabase, ClusterIdentity clusterIdentity, LogProvider logProvider, CoreStateDownloader downloader, CommandApplicationProcess commandApplicationProcess) {
        this.raftMachine = raftMachine;
        this.localDatabase = localDatabase;
        this.clusterIdentity = clusterIdentity;
        this.downloader = downloader;
        this.log = logProvider.getLog(this.getClass());
        this.applicationProcess = commandApplicationProcess;
    }

    @Override
    public synchronized void handle(RaftMessages.ClusterIdAwareMessage clusterIdAwareMessage) {
        block6: {
            if (!this.allowMessageHandling) {
                return;
            }
            ClusterId clusterId = clusterIdAwareMessage.clusterId();
            if (clusterId.equals(this.clusterIdentity.clusterId())) {
                try {
                    ConsensusOutcome outcome = this.raftMachine.handle(clusterIdAwareMessage.message());
                    if (outcome.needsFreshSnapshot()) {
                        this.downloadSnapshot(clusterIdAwareMessage.message().from());
                        break block6;
                    }
                    this.notifyCommitted(outcome.getCommitIndex());
                }
                catch (Throwable e) {
                    this.log.error("Error handling message", e);
                    this.raftMachine.panic();
                    this.localDatabase.panic(e);
                }
            } else {
                this.log.info("Discarding message[%s] owing to mismatched storeId. Expected: %s, Encountered: %s", new Object[]{clusterIdAwareMessage.message(), clusterId, this.clusterIdentity.clusterId()});
            }
        }
    }

    private synchronized void notifyCommitted(long commitIndex) {
        this.applicationProcess.notifyCommitted(commitIndex);
    }

    private synchronized void downloadSnapshot(MemberId source) {
        try {
            this.applicationProcess.sync();
            this.downloader.downloadSnapshot(source, this);
        }
        catch (InterruptedException | StoreCopyFailedException e) {
            this.log.error("Failed to download snapshot", (Throwable)e);
        }
    }

    public synchronized CoreSnapshot snapshot() throws IOException, InterruptedException {
        return this.applicationProcess.snapshot(this.raftMachine);
    }

    public synchronized void installSnapshot(CoreSnapshot coreSnapshot) throws Throwable {
        this.applicationProcess.installSnapshot(coreSnapshot, this.raftMachine);
        this.notifyAll();
    }

    public long lastApplied() {
        return this.applicationProcess.lastApplied();
    }

    @Override
    public void prune() throws IOException {
        this.applicationProcess.prune();
    }

    public synchronized void init() throws Throwable {
        this.localDatabase.init();
        this.applicationProcess.init();
    }

    public synchronized void start() throws Throwable {
        this.clusterIdentity.bindToCluster((ThrowingConsumer<CoreSnapshot, Throwable>)((ThrowingConsumer)this::installSnapshot));
        this.allowMessageHandling = true;
        long endTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(30L);
        while (!this.haveState()) {
            if (System.currentTimeMillis() > endTime) {
                throw new RuntimeException("This machine failed to get the start state in time.");
            }
            this.wait(1000L);
        }
        this.localDatabase.start();
        this.applicationProcess.start();
    }

    private boolean haveState() {
        return this.raftMachine.state().appendIndex() > -1L;
    }

    public synchronized void stop() throws Throwable {
        this.applicationProcess.stop();
        this.localDatabase.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.applicationProcess.shutdown();
        this.localDatabase.shutdown();
    }
}

