/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;

public class InFlightLogEntryReader
implements AutoCloseable {
    private final ReadableRaftLog raftLog;
    private final InFlightMap<RaftLogEntry> inFlightMap;
    private final boolean removeReadIndexFromMap;
    private RaftLogCursor cursor;
    private boolean useInFlightMap = true;

    public InFlightLogEntryReader(ReadableRaftLog raftLog, InFlightMap<RaftLogEntry> inFlightMap, boolean removeReadIndexFromMap) {
        this.raftLog = raftLog;
        this.inFlightMap = inFlightMap;
        this.removeReadIndexFromMap = removeReadIndexFromMap;
    }

    public RaftLogEntry get(long logIndex) throws IOException {
        RaftLogEntry entry = null;
        if (this.useInFlightMap) {
            entry = this.inFlightMap.get(logIndex);
        }
        if (entry == null) {
            this.useInFlightMap = false;
            entry = this.getUsingCursor(logIndex);
        }
        if (this.removeReadIndexFromMap) {
            this.inFlightMap.remove(logIndex);
        }
        return entry;
    }

    private RaftLogEntry getUsingCursor(long logIndex) throws IOException {
        if (this.cursor == null) {
            this.cursor = this.raftLog.getEntryCursor(logIndex);
        }
        if (this.cursor.next()) {
            assert (this.cursor.index() == logIndex) : String.format("expected index %d but was %s", logIndex, this.cursor.index());
            return (RaftLogEntry)this.cursor.get();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

