/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.IdGenerationException;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ReplicatedIdRangeAcquirer {
    private final Replicator replicator;
    private final ReplicatedIdAllocationStateMachine idAllocationStateMachine;
    private final Map<IdType, Integer> allocationSizes;
    private final MemberId me;
    private final Log log;

    public ReplicatedIdRangeAcquirer(Replicator replicator, ReplicatedIdAllocationStateMachine idAllocationStateMachine, Map<IdType, Integer> allocationSizes, MemberId me, LogProvider logProvider) {
        this.replicator = replicator;
        this.idAllocationStateMachine = idAllocationStateMachine;
        this.allocationSizes = allocationSizes;
        this.me = me;
        this.log = logProvider.getLog(this.getClass());
    }

    IdAllocation acquireIds(IdType idType) {
        while (true) {
            long firstUnallocated;
            ReplicatedIdAllocationRequest idAllocationRequest;
            if (this.replicateIdAllocationRequest(idType, idAllocationRequest = new ReplicatedIdAllocationRequest(this.me, idType, firstUnallocated = this.idAllocationStateMachine.firstUnallocated(idType), this.allocationSizes.get(idType)))) {
                IdRange idRange = new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, firstUnallocated, this.allocationSizes.get(idType).intValue());
                return new IdAllocation(idRange, -1L, 0L);
            }
            this.log.info("Retrying ID generation due to conflict. Request was: " + idAllocationRequest);
        }
    }

    private boolean replicateIdAllocationRequest(IdType idType, ReplicatedIdAllocationRequest idAllocationRequest) {
        try {
            return (Boolean)this.replicator.replicate(idAllocationRequest, true).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.error(String.format("Failed to acquire id range for idType %s", idType), (Throwable)e);
            throw new IdGenerationException(e);
        }
    }
}

