/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.TokenRegistry;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.TokenFactory;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTokenStateMachine<TOKEN extends Token>
implements StateMachine<ReplicatedTokenRequest> {
    private TransactionCommitProcess commitProcess;
    private final TokenRegistry<TOKEN> tokenRegistry;
    private final TokenFactory<TOKEN> tokenFactory;
    private final Log log;
    private long lastCommittedIndex = -1L;

    public ReplicatedTokenStateMachine(TokenRegistry<TOKEN> tokenRegistry, TokenFactory<TOKEN> tokenFactory, LogProvider logProvider) {
        this.tokenRegistry = tokenRegistry;
        this.tokenFactory = tokenFactory;
        this.log = logProvider.getLog(this.getClass());
    }

    public synchronized void installCommitProcess(TransactionCommitProcess commitProcess, long lastCommittedIndex) {
        this.commitProcess = commitProcess;
        this.lastCommittedIndex = lastCommittedIndex;
        this.log.info(String.format("(%s) Updated lastCommittedIndex to %d", this.tokenRegistry.getTokenType(), lastCommittedIndex));
    }

    @Override
    public synchronized void applyCommand(ReplicatedTokenRequest tokenRequest, long commandIndex, Consumer<Result> callback) {
        if (commandIndex <= this.lastCommittedIndex) {
            return;
        }
        Integer tokenId = this.tokenRegistry.getId(tokenRequest.tokenName());
        if (tokenId == null) {
            try {
                Collection<StorageCommand> commands = ReplicatedTokenRequestSerializer.extractCommands(tokenRequest.commandBytes());
                tokenId = this.applyToStore(commands, commandIndex);
            }
            catch (NoSuchEntryException e) {
                throw new IllegalStateException("Commands did not contain token command");
            }
            this.tokenRegistry.addToken(this.tokenFactory.newToken(tokenRequest.tokenName(), tokenId.intValue()));
        }
        callback.accept(Result.of(tokenId));
    }

    private int applyToStore(Collection<StorageCommand> commands, long logIndex) throws NoSuchEntryException {
        int tokenId = this.extractTokenId(commands);
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(commands);
        representation.setHeader(LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader(logIndex), 0, 0, 0L, 0L, 0L, 0);
        try (LockGroup ignored = new LockGroup();){
            this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)representation), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        return tokenId;
    }

    private int extractTokenId(Collection<StorageCommand> commands) throws NoSuchEntryException {
        for (StorageCommand command : commands) {
            if (!(command instanceof Command.TokenCommand)) continue;
            return ((Command.TokenCommand)command).getAfter().getIntId();
        }
        throw new NoSuchEntryException("Expected command not found");
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    @Override
    public long lastAppliedIndex() {
        if (this.commitProcess == null) {
            throw new IllegalStateException("Value has not been installed");
        }
        return this.lastCommittedIndex;
    }
}

