/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.state.machines.tx.RetryStrategy;

public class ExponentialBackoffStrategy
implements RetryStrategy {
    protected final long initialBackoffTimeMillis;

    public ExponentialBackoffStrategy(long initialBackoffTime, TimeUnit timeUnit) {
        this.initialBackoffTimeMillis = timeUnit.toMillis(initialBackoffTime);
    }

    @Override
    public RetryStrategy.Timeout newTimeout() {
        return new RetryStrategy.Timeout(){
            private long backoffTimeMillis;
            {
                this.backoffTimeMillis = ExponentialBackoffStrategy.this.initialBackoffTimeMillis;
            }

            @Override
            public long getMillis() {
                return this.backoffTimeMillis;
            }

            @Override
            public void increment() {
                this.backoffTimeMillis *= 2L;
            }
        };
    }
}

