/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

public class LogIndexTxHeaderEncoding {
    public static byte[] encodeLogIndexAsTxHeader(long logIndex) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)logIndex;
            logIndex >>>= 8;
        }
        b[0] = (byte)logIndex;
        return b;
    }

    public static long decodeLogIndexFromTxHeader(byte[] bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("Unable to decode RAFT log index from transaction header");
        }
        long logIndex = 0L;
        for (int i = 0; i < 8; ++i) {
            logIndex <<= 8;
            logIndex ^= (long)(bytes[i] & 0xFF);
        }
        return logIndex;
    }
}

