/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.messaging.MessageTooBigException;
import org.neo4j.causalclustering.messaging.NetworkFlushableChannelNetty4;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public class ReplicatedTransactionFactory {
    private static final long MAX_SERIALIZED_TX_SIZE = ByteUnit.gibiBytes((long)1L);

    public static ReplicatedTransaction createImmutableReplicatedTransaction(TransactionRepresentation tx) {
        ByteBuf transactionBuffer = Unpooled.buffer();
        NetworkFlushableChannelNetty4 channel = new NetworkFlushableChannelNetty4(transactionBuffer, MAX_SERIALIZED_TX_SIZE);
        try {
            TransactionSerializer.write(tx, channel);
        }
        catch (MessageTooBigException e) {
            throw new IllegalStateException("Transaction size was too large to replicate across the cluster.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] txBytes = Arrays.copyOf(transactionBuffer.array(), transactionBuffer.writerIndex());
        transactionBuffer.release();
        return new ReplicatedTransaction(txBytes);
    }

    public static TransactionRepresentation extractTransactionRepresentation(ReplicatedTransaction transactionCommand, byte[] extraHeader) {
        ByteBuf txBuffer = Unpooled.wrappedBuffer((byte[])transactionCommand.getTxBytes());
        NetworkReadableClosableChannelNetty4 channel = new NetworkReadableClosableChannelNetty4(txBuffer);
        try {
            return ReplicatedTransactionFactory.read(channel, extraHeader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransactionRepresentation read(NetworkReadableClosableChannelNetty4 channel, byte[] extraHeader) throws IOException {
        LogEntryCommand entryRead;
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory());
        int authorId = channel.getInt();
        int masterId = channel.getInt();
        long latestCommittedTxWhenStarted = channel.getLong();
        long timeStarted = channel.getLong();
        long timeCommitted = channel.getLong();
        int lockSessionId = channel.getInt();
        int headerLength = channel.getInt();
        byte[] header = headerLength == 0 ? extraHeader : new byte[headerLength];
        channel.get(header, headerLength);
        LinkedList<StorageCommand> commands = new LinkedList<StorageCommand>();
        while ((entryRead = (LogEntryCommand)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel)) != null) {
            commands.add(entryRead.getXaCommand());
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(header, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, lockSessionId);
        return tx;
    }

    private static class TransactionSerializer {
        private TransactionSerializer() {
        }

        public static void write(TransactionRepresentation tx, NetworkFlushableChannelNetty4 channel) throws IOException {
            channel.putInt(tx.getAuthorId());
            channel.putInt(tx.getMasterId());
            channel.putLong(tx.getLatestCommittedTxWhenStarted());
            channel.putLong(tx.getTimeStarted());
            channel.putLong(tx.getTimeCommitted());
            channel.putInt(tx.getLockSessionId());
            byte[] additionalHeader = tx.additionalHeader();
            if (additionalHeader != null) {
                channel.putInt(additionalHeader.length);
                channel.put(additionalHeader, additionalHeader.length);
            } else {
                channel.putInt(0);
            }
            new LogEntryWriter((FlushableChannel)channel).serialize(tx);
        }
    }
}

