/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreSnapshot {
    private final long prevIndex;
    private final long prevTerm;
    private final Map<CoreStateType, Object> snapshotCollection = new HashMap<CoreStateType, Object>();

    public CoreSnapshot(long prevIndex, long prevTerm) {
        this.prevIndex = prevIndex;
        this.prevTerm = prevTerm;
    }

    public long prevIndex() {
        return this.prevIndex;
    }

    public long prevTerm() {
        return this.prevTerm;
    }

    public void add(CoreStateType type, Object state) {
        this.snapshotCollection.put(type, state);
    }

    public <T> T get(CoreStateType type) {
        return (T)this.snapshotCollection.get((Object)type);
    }

    public Iterable<CoreStateType> types() {
        return this.snapshotCollection.keySet();
    }

    public int size() {
        return this.snapshotCollection.size();
    }

    public String toString() {
        return String.format("CoreSnapshot{prevIndex=%d, prevTerm=%d, snapshotCollection=%s}", this.prevIndex, this.prevTerm, this.snapshotCollection);
    }

    public static class Marshal
    extends SafeChannelMarshal<CoreSnapshot> {
        @Override
        public void marshal(CoreSnapshot coreSnapshot, WritableChannel buffer) throws IOException {
            buffer.putLong(coreSnapshot.prevIndex);
            buffer.putLong(coreSnapshot.prevTerm);
            buffer.putInt(coreSnapshot.size());
            for (CoreStateType type : coreSnapshot.types()) {
                buffer.putInt(type.ordinal());
                type.marshal.marshal(coreSnapshot.get(type), buffer);
            }
        }

        @Override
        public CoreSnapshot unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            long prevIndex = channel.getLong();
            long prevTerm = channel.getLong();
            CoreSnapshot coreSnapshot = new CoreSnapshot(prevIndex, prevTerm);
            int snapshotCount = channel.getInt();
            for (int i = 0; i < snapshotCount; ++i) {
                int typeOrdinal = channel.getInt();
                CoreStateType type = CoreStateType.values()[typeOrdinal];
                Object state = type.marshal.unmarshal(channel);
                coreSnapshot.add(type, state);
            }
            return coreSnapshot;
        }
    }
}

