/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Set;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RaftDiscoveryServiceConnector
extends LifecycleAdapter
implements CoreTopologyService.Listener {
    private final CoreTopologyService discoveryService;
    private final RaftMachine raftMachine;

    public RaftDiscoveryServiceConnector(CoreTopologyService discoveryService, RaftMachine raftMachine) {
        this.discoveryService = discoveryService;
        this.raftMachine = raftMachine;
    }

    public void start() throws RaftMachine.BootstrapException {
        this.discoveryService.addCoreTopologyListener(this);
    }

    @Override
    public synchronized void onCoreTopologyChange(CoreTopology coreTopology) {
        Set<MemberId> targetMembers = coreTopology.members();
        this.raftMachine.setTargetMembershipSet(targetMembers);
    }
}

