/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.handlers;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import org.neo4j.logging.Log;

public class ExceptionLoggingHandler
extends ChannelHandlerAdapter {
    private final Log log;

    public ExceptionLoggingHandler(Log log) {
        this.log = log;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log.error(this.message(ctx), cause);
        ctx.fireExceptionCaught(cause);
    }

    private String message(ChannelHandlerContext ctx) {
        return ctx != null ? String.format("Failed to process message on channel %s.", ctx.channel()) : "Failed to process message on a null channel.";
    }
}

