/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.io.OutputStream;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;

public class StatUtil {
    public static synchronized StatContext create(String name, long printEvery, boolean clearAfterPrint) {
        return StatUtil.create(name, FormattedLogProvider.toOutputStream((OutputStream)System.out).getLog(name), printEvery, clearAfterPrint);
    }

    public static synchronized StatContext create(String name, Log log, long printEvery, boolean clearAfterPrint) {
        return new StatContext(name, log, printEvery, clearAfterPrint);
    }

    private static class BasicStats {
        private Double min;
        private Double max;
        private Double avg = 0.0;
        private long count;

        private BasicStats() {
        }

        void collect(double val) {
            ++this.count;
            this.avg = this.avg + (val - this.avg) / (double)this.count;
            this.min = this.min == null ? val : Math.min(this.min, val);
            this.max = this.max == null ? val : Math.max(this.max, val);
        }

        public String toString() {
            return String.format("{min=%s, max=%s, avg=%s, count=%d}", this.min, this.max, this.avg, this.count);
        }
    }

    public static class TimingContext {
        private final StatContext context;
        private final long startTime = System.currentTimeMillis();

        TimingContext(StatContext context) {
            this.context = context;
        }

        public void end() {
            this.context.collect(System.currentTimeMillis() - this.startTime);
        }
    }

    public static class StatContext {
        private static final int N_BUCKETS = 10;
        private final String name;
        private final Log log;
        private final long printEvery;
        private final boolean clearAfterPrint;
        private BasicStats[] bucket = new BasicStats[10];
        private long totalCount;

        private StatContext(String name, Log log, long printEvery, boolean clearAfterPrint) {
            this.name = name;
            this.log = log;
            this.printEvery = printEvery;
            this.clearAfterPrint = clearAfterPrint;
            this.clear();
        }

        public synchronized void clear() {
            for (int i = 0; i < 10; ++i) {
                this.bucket[i] = new BasicStats();
            }
            this.totalCount = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void collect(double value) {
            int bucketIndex = this.bucketFor(value);
            StatContext statContext = this;
            synchronized (statContext) {
                ++this.totalCount;
                this.bucket[bucketIndex].collect(value);
                if (this.totalCount % this.printEvery == 0L) {
                    this.print();
                }
            }
        }

        private int bucketFor(double value) {
            int bucketIndex;
            if (value <= 0.0) {
                bucketIndex = 0;
            } else {
                bucketIndex = (int)Math.log10(value);
                bucketIndex = Math.min(bucketIndex, 9);
            }
            return bucketIndex;
        }

        public TimingContext time() {
            return new TimingContext(this);
        }

        public synchronized void print() {
            for (BasicStats stats : this.bucket) {
                if (stats.count <= 0L) continue;
                this.log.info(String.format("%s%s", this.name, stats));
            }
            if (this.clearAfterPrint) {
                this.clear();
            }
        }
    }
}

