/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.time.Clock;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.storage.SimpleStorage;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.BindingException;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterIdentity {
    private final SimpleStorage<ClusterId> clusterIdStorage;
    private final CoreTopologyService topologyService;
    private final CoreBootstrapper coreBootstrapper;
    private final Log log;
    private final Clock clock;
    private final ThrowingAction<InterruptedException> retryWaiter;
    private final long timeoutMillis;
    private ClusterId clusterId;

    public ClusterIdentity(SimpleStorage<ClusterId> clusterIdStorage, CoreTopologyService topologyService, LogProvider logProvider, Clock clock, ThrowingAction<InterruptedException> retryWaiter, long timeoutMillis, CoreBootstrapper coreBootstrapper) {
        this.clusterIdStorage = clusterIdStorage;
        this.topologyService = topologyService;
        this.coreBootstrapper = coreBootstrapper;
        this.log = logProvider.getLog(this.getClass());
        this.clock = clock;
        this.retryWaiter = retryWaiter;
        this.timeoutMillis = timeoutMillis;
    }

    public void bindToCluster(ThrowingConsumer<CoreSnapshot, Throwable> snapshotInstaller) throws Throwable {
        if (this.clusterIdStorage.exists()) {
            ClusterId localClusterId = this.clusterIdStorage.readState();
            this.publishClusterId(localClusterId);
            this.clusterId = localClusterId;
        } else {
            ClusterId commonClusterId;
            CoreTopology topology = this.topologyService.coreServers();
            if (topology.canBeBootstrapped()) {
                commonClusterId = new ClusterId(UUID.randomUUID());
                CoreSnapshot snapshot = this.coreBootstrapper.bootstrap(topology.members());
                this.log.info(String.format("Bootstrapped with snapshot: %s and clusterId: %s", snapshot, commonClusterId));
                snapshotInstaller.accept((Object)snapshot);
                this.publishClusterId(commonClusterId);
            } else {
                long endTime = this.clock.millis() + this.timeoutMillis;
                this.log.info("Attempting to bind to : " + topology);
                while ((commonClusterId = topology.clusterId()) == null) {
                    if (this.clock.millis() < endTime) {
                        this.retryWaiter.apply();
                        this.topologyService.refreshCoreTopology();
                        topology = this.topologyService.coreServers();
                        continue;
                    }
                    throw new TimeoutException(String.format("Failed to join a cluster with members %s. Another member should have published a clusterId but none was detected. Please restart the cluster.", topology));
                }
                this.log.info("Bound to cluster: " + commonClusterId);
            }
            this.clusterIdStorage.writeState(commonClusterId);
            this.clusterId = commonClusterId;
        }
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    private void publishClusterId(ClusterId localClusterId) throws BindingException {
        boolean success = this.topologyService.setClusterId(localClusterId);
        if (!success) {
            throw new BindingException("Failed to publish: " + localClusterId);
        }
        this.log.info("Published: " + localClusterId);
    }
}

