/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.Message;

public class LoggingInbound<M extends Message>
implements Inbound<M> {
    private final Inbound<M> inbound;
    private final MessageLogger<MemberId> messageLogger;
    private final MemberId me;

    public LoggingInbound(Inbound<M> inbound, MessageLogger<MemberId> messageLogger, MemberId me) {
        this.inbound = inbound;
        this.messageLogger = messageLogger;
        this.me = me;
    }

    @Override
    public void registerHandler(final Inbound.MessageHandler<M> handler) {
        this.inbound.registerHandler(new Inbound.MessageHandler<M>(){

            @Override
            public synchronized void handle(M message) {
                LoggingInbound.this.messageLogger.log(LoggingInbound.this.me, message);
                handler.handle(message);
            }
        });
    }
}

