/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class WaitForUpToDateStore
extends LifecycleAdapter {
    private final CatchupPollingProcess catchupProcess;
    private final Log log;

    WaitForUpToDateStore(CatchupPollingProcess catchupProcess, LogProvider logProvider) {
        this.catchupProcess = catchupProcess;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.waitForUpToDateStore();
    }

    private void waitForUpToDateStore() throws InterruptedException, ExecutionException {
        boolean upToDate = false;
        do {
            try {
                upToDate = this.catchupProcess.upToDateFuture().get(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                this.log.warn("Waiting for up-to-date store is taking an unusually long time");
            }
        } while (!upToDate);
    }
}

