/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public abstract class CatchingIteratorWrapper<T, U>
extends PrefetchingIterator<T> {
    private final Iterator<U> source;

    public CatchingIteratorWrapper(Iterator<U> source) {
        this.source = source;
    }

    @Override
    protected T fetchNextOrNull() {
        while (this.source.hasNext()) {
            U nextItem = null;
            try {
                nextItem = this.fetchNextOrNullFromSource(this.source);
                if (nextItem == null) continue;
                return this.underlyingObjectToObject(nextItem);
            }
            catch (Throwable t) {
                if (this.exceptionOk(t)) {
                    this.itemDodged(nextItem);
                    continue;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
        }
        return null;
    }

    protected U fetchNextOrNullFromSource(Iterator<U> source) {
        return source.next();
    }

    protected void itemDodged(U item) {
    }

    protected boolean exceptionOk(Throwable t) {
        return true;
    }

    protected abstract T underlyingObjectToObject(U var1);
}

