/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.CypherExpressionEngineOption;
import org.neo4j.cypher.CypherExpressionEngineOption$onlyWhenHot$;
import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherUpdateStrategy;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.runtime.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5b\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB!1\b\u0011\"J\u001b\u0005a$BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u007f\u0019\tq\u0001[3ma\u0016\u00148/\u0003\u0002By\t!\u0001+Y5s!\t\u0019eI\u0004\u0002\u000e\t&\u0011QID\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F\u001dA\u0011!\n\u0017\b\u0003\u0017Zs!\u0001T+\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\t&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005]\u0013\u0011AC)vKJL8)Y2iK&\u0011\u0011L\u0017\u0002\u0011!\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCBT!a\u0016\u0002\t\u0011q\u0003!\u0011!Q\u0001\nY\nAbY1dQ\u0016$&/Y2fe\u0002B\u0001B\u0018\u0001\u0003\u0006\u0004%\taX\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0004\"aN1\n\u0005\t\u0014!aE\"za\",'oQ8oM&<WO]1uS>t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00021\u0002\u000f\r|gNZ5hA!Aa\r\u0001BC\u0002\u0013\u0005q-\u0001\u000bd_6\u0004\u0018\r^5cS2LG/\u001f$bGR|'/_\u000b\u0002QB\u0011q'[\u0005\u0003U\n\u0011qbQ8na&dWM\u001d$bGR|'/\u001f\u0005\tY\u0002\u0011\t\u0011)A\u0005Q\u0006)2m\\7qCRL'-\u001b7jif4\u0015m\u0019;pef\u0004\u0003\u0002\u00038\u0001\u0005\u000b\u0007I\u0011A8\u0002\u00171|w\r\u0015:pm&$WM]\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\bY><w-\u001b8h\u0013\t)(OA\u0006M_\u001e\u0004&o\u001c<jI\u0016\u0014\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u00029\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\t\u0011e\u0004!Q1A\u0005\u0002i\fQa\u00197pG.,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018\u0001\u0002;j[\u0016T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bi(!B\"m_\u000e\\\u0007\"CA\u0005\u0001\t\u0005\t\u0015!\u0003|\u0003\u0019\u0019Gn\\2lA!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011A\u0002\u001fj]&$h\b\u0006\n\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u0002CA\u001c\u0001\u0011\u0019\u0019\u00121\u0002a\u0001+!1a$a\u0003A\u0002\u0001Ba!KA\u0006\u0001\u0004Y\u0003B\u0002\u001b\u0002\f\u0001\u0007a\u0007\u0003\u0004_\u0003\u0017\u0001\r\u0001\u0019\u0005\u0007M\u0006-\u0001\u0019\u00015\t\r9\fY\u00011\u0001q\u0011!I\u00181\u0002I\u0001\u0002\u0004Y\b\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0003U\tX/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005)\u0011/^3ss*\u0019\u00111G\f\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003o\tiCA\u000bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\t\u0011\u0005m\u0002\u0001)A\u0005\u0003S\ta#];fef,\u00050Z2vi&|g.T8oSR|'\u000f\t\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003\n\u0011\u0002\u001d:f!\u0006\u00148/\u001a:\u0016\u0005\u0005\r\u0003cA\u001c\u0002F%\u0019\u0011q\t\u0002\u0003\u0013A\u0013X\rU1sg\u0016\u0014\b\u0002CA&\u0001\u0001\u0006I!a\u0011\u0002\u0015A\u0014X\rU1sg\u0016\u0014\b\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R\u0005IB.Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0004\u0003;\u0012\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003C\n9FA\rMCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\b\u0002CA3\u0001\u0001\u0006I!a\u0015\u000251\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM\u001d\u0011\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\u0005\u0001\u0002\u000f\\1o%\u0016,8/\u00192jY&$\u0018.\u001f\u000b\u0007\u0003[\n\u0019(! \u0011\u0007]\ny'C\u0002\u0002r\t\u0011\u0001CU3vg\u0006\u0014\u0017\u000e\\5usN#\u0018\r^3\t\u0011\u0005U\u0014q\ra\u0001\u0003o\nq\"\u001a=fGV$\u0018M\u00197f#V,'/\u001f\t\u0004o\u0005e\u0014bAA>\u0005\tyQ\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010\u0003\u0005\u0002\u0000\u0005\u001d\u0004\u0019AAA\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB!\u00111FAB\u0013\u0011\t))!\f\u0003)Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0011%\tI\t\u0001b\u0001\n\u0013\tY)A\u0002m_\u001e,\"!!$\u0011\u0007E\fy)C\u0002\u0002\u0012J\u00141\u0001T8h\u0011!\t)\n\u0001Q\u0001\n\u00055\u0015\u0001\u00027pO\u0002B\u0011\"!'\u0001\u0005\u0004%I!a'\u0002'Ad\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\u0016\u0005\u0005u\u0005#B\u001c\u0002 \u0006]\u0014bAAQ\u0005\t\u0019\u0002\u000b\\1o'R\fG.\u001a8fgN\u001c\u0015\r\u001c7fe\"A\u0011Q\u0015\u0001!\u0002\u0013\ti*\u0001\u000bqY\u0006t7\u000b^1mK:,7o]\"bY2,'\u000f\t\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003W\u000b!\"];fef\u001c\u0015m\u00195f+\t\ti\u000bE\u00048\u0003_\u0013%(a\u001e\n\u0007\u0005E&A\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016D\u0001\"!.\u0001A\u0003%\u0011QV\u0001\fcV,'/_\"bG\",\u0007\u0005C\u0005\u0002:\u0002\u0011\r\u0011\"\u0003\u0002<\u0006qQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014XCAA_!\r9\u0014qX\u0005\u0004\u0003\u0003\u0014!AD'bgR,'oQ8na&dWM\u001d\u0005\t\u0003\u000b\u0004\u0001\u0015!\u0003\u0002>\u0006yQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0005C\u0005\u0002J\u0002\u0011\r\u0011\"\u0003\u0002L\u0006a1o\u00195f[\u0006DU\r\u001c9feV\u0011\u0011Q\u001a\t\u0004o\u0005=\u0017bAAi\u0005\ta1k\u00195f[\u0006DU\r\u001c9fe\"A\u0011Q\u001b\u0001!\u0002\u0013\ti-A\u0007tG\",W.\u0019%fYB,'\u000f\t\u0005\b\u00033\u0004A\u0011AAn\u0003\u001d\u0001(o\u001c4jY\u0016$\u0002\"!8\u0002j\u0006-\u0018q \t\u0005\u0003?\f)/\u0004\u0002\u0002b*\u0019\u00111\u001d\u0004\u0002\u000f\u001d\u0014\u0018\r\u001d5eE&!\u0011q]Aq\u0005\u0019\u0011Vm];mi\"9\u0011qFAl\u0001\u0004\u0011\u0005\u0002CAw\u0003/\u0004\r!a<\u0002\rA\f'/Y7t!\u0011\t\t0a?\u000e\u0005\u0005M(\u0002BA{\u0003o\fqA^5siV\fGNC\u0002\u0002z\u001a\taA^1mk\u0016\u001c\u0018\u0002BA\u007f\u0003g\u0014\u0001\"T1q-\u0006dW/\u001a\u0005\t\u0005\u0003\t9\u000e1\u0001\u0002\u0002\u000691m\u001c8uKb$\bb\u0002B\u0003\u0001\u0011\u0005!qA\u0001\bKb,7-\u001e;f))\tiN!\u0003\u0003\f\t5!q\u0002\u0005\b\u0003_\u0011\u0019\u00011\u0001C\u0011!\tiOa\u0001A\u0002\u0005=\b\u0002\u0003B\u0001\u0005\u0007\u0001\r!!!\t\u0015\u0005e'1\u0001I\u0001\u0002\u0004\u0011\t\u0002E\u0002\u000e\u0005'I1A!\u0006\u000f\u0005\u001d\u0011un\u001c7fC:DqA!\u0007\u0001\t\u0013\u0011Y\"A\u0005d_6\u0004\u0018\u000e\\3sgRQ!Q\u0004B\u001e\u0005\u000b\u0012IFa\u0017\u0011\u000f5\u0011yBa\t\u0003*%\u0019!\u0011\u0005\b\u0003\rQ+\b\u000f\\33!\u0015i!QEA<\u0013\r\u00119C\u0004\u0002\n\rVt7\r^5p]B\u0002r!\u0004B\u0016\u0005_\u0011)$C\u0002\u0003.9\u0011\u0011BR;oGRLwN\\\u0019\u0011\u00075\u0011\t$C\u0002\u000349\u00111!\u00138u!\u0015i!qGA<\u0013\r\u0011ID\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\tu\"q\u0003a\u0001\u0005\u007f\ta\u0002\u001d:f!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010E\u00028\u0005\u0003J1Aa\u0011\u0003\u00059\u0001&/\u001a)beN,G-U;fefDq!\u000bB\f\u0001\u0004\u00119\u0005\u0005\u0003\u0003J\tMc\u0002\u0002B&\u0005\u001fr1a\u0013B'\u0013\tq#!C\u0002\u0003R5\n\u0011cQ8na&d\u0017\r^5p]R\u0013\u0018mY3s\u0013\u0011\u0011)Fa\u0016\u0003+E+XM]=D_6\u0004\u0018\u000e\\1uS>tWI^3oi*\u0019!\u0011K\u0017\t\u0011\u0005}$q\u0003a\u0001\u0003\u0003C\u0001\"!<\u0003\u0018\u0001\u0007\u0011q\u001e\u0005\b\u0005?\u0002A\u0011\u0002B1\u000319W\r^(s\u0007>l\u0007/\u001b7f))\t9Ha\u0019\u0003f\t\u001d$\u0011\u000e\u0005\t\u0005\u0003\u0011i\u00061\u0001\u0002\u0002\"A!Q\bB/\u0001\u0004\u0011y\u0004C\u0004*\u0005;\u0002\rAa\u0012\t\u0011\u00055(Q\fa\u0001\u0003_DqA!\u001c\u0001\t\u0003\u0011y'\u0001\tdY\u0016\f'/U;fef\u001c\u0015m\u00195fgR\u0011!\u0011\u000f\t\u0004\u001b\tM\u0014b\u0001B;\u001d\t!Aj\u001c8h\u0011\u001d\u0011I\b\u0001C\u0001\u0005w\n\u0001#[:QKJLw\u000eZ5d\u0007>lW.\u001b;\u0015\t\tE!Q\u0010\u0005\b\u0003_\u00119\b1\u0001C\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000bqb\u00195fG.\u0004\u0016M]1nKR,'o\u001d\u000b\t\u0005\u000b\u0013YI!)\u0003&B\u0019QBa\"\n\u0007\t%eB\u0001\u0003V]&$\b\u0002\u0003BG\u0005\u007f\u0002\rAa$\u0002\u0017E,XM]=QCJ\fWn\u001d\t\u0006\u0005#\u0013YJ\u0011\b\u0005\u0005'\u00139JD\u0002P\u0005+K\u0011aD\u0005\u0004\u00053s\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005;\u0013yJA\u0002TKFT1A!'\u000f\u0011!\u0011\u0019Ka A\u0002\u0005=\u0018aC4jm\u0016t\u0007+\u0019:b[ND\u0001Ba*\u0003\u0000\u0001\u0007\u0011q^\u0001\u0010Kb$(/Y2uK\u0012\u0004\u0016M]1ng\"2!q\u0010BV\u0005s\u0003R!\u0004BW\u0005cK1Aa,\u000f\u0005\u0019!\bN]8xgB!!1\u0017B[\u001b\u0005!\u0011b\u0001B\\\t\tQ\u0002+\u0019:b[\u0016$XM\u001d(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!\u0011\u0017\u0005\b\u0005{\u0003A\u0011\u0002B`\u0003!\u0019X\u000f\u001d9mS\u0016\u0014X\u0003\u0002Ba\u0005/$BAa1\u0003jB1!Q\u0019Bh\u0005'l!Aa2\u000b\t\t%'1Z\u0001\tMVt7\r^5p]*\u0019!QZ@\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005#\u00149M\u0001\u0005TkB\u0004H.[3s!\u0011\u0011)Na6\r\u0001\u0011A!\u0011\u001cB^\u0005\u0004\u0011YNA\u0001U#\u0011\u0011iNa9\u0011\u00075\u0011y.C\u0002\u0003b:\u0011qAT8uQ&tw\rE\u0002\u000e\u0005KL1Aa:\u000f\u0005\r\te.\u001f\u0005\n\u0005W\u0014Y\f\"a\u0001\u0005[\f\u0011\u0001\u001e\t\u0006\u001b\t=(1[\u0005\u0004\u0005ct!\u0001\u0003\u001fcs:\fW.\u001a \t\u0013\tU\b!%A\u0005\u0002\t]\u0018!E3yK\u000e,H/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011 \u0016\u0005\u0005#\u0011Yp\u000b\u0002\u0003~B!!q`B\u0005\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011!C;oG\",7m[3e\u0015\r\u00199AD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0006\u0007\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u0019yA\u0001E\u0001\u0007#\tq\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\t\u0004o\rMaAB\u0001\u0003\u0011\u0003\u0019)bE\u0002\u0004\u00141A\u0001\"!\u0004\u0004\u0014\u0011\u00051\u0011\u0004\u000b\u0003\u0007#A!b!\b\u0004\u0014\t\u0007I\u0011AB\u0010\u0003M\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#T+\t\u0011y\u0003C\u0005\u0004$\rM\u0001\u0015!\u0003\u00030\u0005!\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'\u0002B!ba\n\u0004\u0014E\u0005I\u0011AB\u0015\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u001111\u0006\u0016\u0004w\nm\b")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor queryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache;
    private final MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor queryExecutionMonitor() {
        return this.queryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile2) {
        Tuple3 tuple3;
        block5: {
            Tuple3 tuple32;
            CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
            tuple3 = this.parseAndCompile$1(query, params, context, profile2, queryTracer);
            if (tuple3 == null) break block5;
            ExecutableQuery executableQuery = (ExecutableQuery)tuple3._1();
            PreParsedQuery preParsedQuery = (PreParsedQuery)tuple3._2();
            MapValue combinedParams = (MapValue)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)executableQuery, (Object)preParsedQuery, (Object)combinedParams);
            ExecutableQuery executableQuery2 = (ExecutableQuery)tuple33._1();
            PreParsedQuery preParsedQuery2 = (PreParsedQuery)tuple33._2();
            MapValue combinedParams2 = (MapValue)tuple33._3();
            Result result = executableQuery2.execute(context, preParsedQuery2, combinedParams2);
            queryTracer.close();
            {
                catch (Throwable throwable) {
                    context.close(false);
                    throw throwable;
                }
            }
            return result;
        }
        try {
            throw new MatchError((Object)tuple3);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
    }

    public boolean execute$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> compilers(PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        boolean bl = false;
        CypherExpressionEngineOption cypherExpressionEngineOption = null;
        CypherExpressionEngineOption cypherExpressionEngineOption2 = preParsedQuery.expressionEngine();
        if (CypherExpressionEngineOption$onlyWhenHot$.MODULE$.equals(cypherExpressionEngineOption2)) {
            bl = true;
            cypherExpressionEngineOption = cypherExpressionEngineOption2;
            if (this.config().recompilationLimit() > 0) {
                Serializable primary = new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext transactionalContext$1;
                    private final MapValue params$2;

                    public final ExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.transactionalContext$1, this.params$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.transactionalContext$1 = transactionalContext$1;
                        this.params$2 = params$2;
                    }
                };
                Serializable secondary = new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext transactionalContext$1;
                    private final MapValue params$2;

                    public final Option<ExecutableQuery> apply(int count) {
                        None$ none$;
                        if (count > this.$outer.config().recompilationLimit()) {
                            boolean x$5 = true;
                            String x$6 = this.preParsedQuery$1.copy$default$1();
                            InputPosition x$7 = this.preParsedQuery$1.copy$default$2();
                            String x$8 = this.preParsedQuery$1.copy$default$3();
                            boolean x$9 = this.preParsedQuery$1.copy$default$4();
                            CypherVersion x$10 = this.preParsedQuery$1.copy$default$5();
                            CypherExecutionMode x$11 = this.preParsedQuery$1.copy$default$6();
                            CypherPlannerOption x$12 = this.preParsedQuery$1.copy$default$7();
                            CypherRuntimeOption x$13 = this.preParsedQuery$1.copy$default$8();
                            CypherUpdateStrategy x$14 = this.preParsedQuery$1.copy$default$9();
                            CypherExpressionEngineOption x$15 = this.preParsedQuery$1.copy$default$10();
                            Set<String> x$16 = this.preParsedQuery$1.copy$default$11();
                            Some some = new Some((Object)this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$5), this.tracer$1, this.transactionalContext$1, this.params$2));
                            none$ = some;
                        } else {
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.transactionalContext$1 = transactionalContext$1;
                        this.params$2 = params$2;
                    }
                };
                return new Tuple2((Object)primary, (Object)secondary);
            }
        }
        if (!bl) return new Tuple2((Object)new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$1;
            private final CompilationTracer.QueryCompilationEvent tracer$1;
            private final TransactionalContext transactionalContext$1;
            private final MapValue params$2;

            public final ExecutableQuery apply() {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.transactionalContext$1, this.params$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$1 = preParsedQuery$1;
                this.tracer$1 = tracer$1;
                this.transactionalContext$1 = transactionalContext$1;
                this.params$2 = params$2;
            }
        }, (Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply(int x$3) {
                return None$.MODULE$;
            }
        });
        return new Tuple2((Object)new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$1;
            private final CompilationTracer.QueryCompilationEvent tracer$1;
            private final TransactionalContext transactionalContext$1;
            private final MapValue params$2;

            public final ExecutableQuery apply() {
                boolean x$17 = true;
                String x$18 = this.preParsedQuery$1.copy$default$1();
                InputPosition x$19 = this.preParsedQuery$1.copy$default$2();
                String x$20 = this.preParsedQuery$1.copy$default$3();
                boolean x$21 = this.preParsedQuery$1.copy$default$4();
                CypherVersion x$22 = this.preParsedQuery$1.copy$default$5();
                CypherExecutionMode x$23 = this.preParsedQuery$1.copy$default$6();
                CypherPlannerOption x$24 = this.preParsedQuery$1.copy$default$7();
                CypherRuntimeOption x$25 = this.preParsedQuery$1.copy$default$8();
                CypherUpdateStrategy x$26 = this.preParsedQuery$1.copy$default$9();
                CypherExpressionEngineOption x$27 = this.preParsedQuery$1.copy$default$10();
                Set<String> x$28 = this.preParsedQuery$1.copy$default$11();
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1.copy(x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$17), this.tracer$1, this.transactionalContext$1, this.params$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$1 = preParsedQuery$1;
                this.tracer$1 = tracer$1;
                this.transactionalContext$1 = transactionalContext$1;
                this.params$2 = params$2;
            }
        }, (Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply(int x$2) {
                return None$.MODULE$;
            }
        });
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        Pair cacheKey = Pair.of((Object)preParsedQuery.statementWithVersionAndPlanner(), QueryCache$.MODULE$.extractParameterTypeMap(params));
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> tuple2 = this.compilers(preParsedQuery, tracer, tc, params);
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple22;
                    Function0 primaryCompiler = (Function0)tuple2._1();
                    Function1 secondaryCompiler = (Function1)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryCompiler, (Object)secondaryCompiler);
                    Function0 primaryCompiler2 = (Function0)tuple23._1();
                    Function1 secondaryCompiler2 = (Function1)tuple23._2();
                    CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)primaryCompiler2, (Function1<Object, Option<ExecutableQuery>>)secondaryCompiler2, preParsedQuery.rawStatement());
                    CacheLookup<ExecutableQuery> cacheLookup2 = cacheLookup;
                    boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                    if (bl) {
                        ExecutableQuery executableQuery = cacheLookup.executableQuery();
                        if (this.schemaHelper().lockLabels(schemaToken, executableQuery, preParsedQuery.version(), tc)) {
                            tc.cleanForReuse();
                            return executableQuery;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (cacheLookup2 instanceof CacheMiss) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw new MatchError(cacheLookup2);
                }
                throw new MatchError(tuple2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$29 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)((SeqLike)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).distinct();
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$30 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$29);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$29, x$30);
    }

    private <T> Supplier<T> supplier(Function0<T> t) {
        return new Supplier<T>(this, t){
            private final Function0 t$1;

            public T get() {
                return (T)this.t$1.apply();
            }
            {
                this.t$1 = t$1;
            }
        };
    }

    private final Tuple3 parseAndCompile$1(String query$1, MapValue params$1, TransactionalContext context$1, boolean profile$1, CompilationTracer.QueryCompilationEvent queryTracer$1) {
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query$1, profile$1);
            ExecutableQuery executableQuery = this.getOrCompile(context$1, preParsedQuery, queryTracer$1, params$1);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params$1, executableQuery.extractedParams());
            }
            MapValue combinedParams = params$1.updatedWith(executableQuery.extractedParams());
            context$1.executingQuery().compilationCompleted(executableQuery.compilerInfo(), this.supplier((Function0)new Serializable(this, executableQuery){
                public static final long serialVersionUID = 0L;
                private final ExecutableQuery executableQuery$1;

                public final InternalPlanDescription apply() {
                    return this.executableQuery$1.planDescription();
                }
                {
                    this.executableQuery$1 = executableQuery$1;
                }
            }));
            return new Tuple3((Object)executableQuery, (Object)preParsedQuery, (Object)combinedParams);
        }
        catch (Throwable throwable) {
            this.queryExecutionMonitor().endFailure(context$1.executingQuery(), throwable.getMessage());
            throw throwable;
        }
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer, CypherConfiguration config, CompilerFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.queryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheRecompile(Object key) {
                CypherCacheHitMonitor$class.cacheRecompile(this, key);
            }

            public void cacheDiscard(Pair<String, Map<String, Class<?>>> ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(executableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler = new MasterCompiler(config, new CompilerLibrary(compatibilityFactory));
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

