/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.CypherExpressionEngineOption;
import org.neo4j.cypher.CypherExpressionEngineOption$;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption$;
import org.neo4j.cypher.CypherOperatorEngineOption;
import org.neo4j.cypher.CypherOperatorEngineOption$;
import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherPlannerOption$;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherRuntimeOption$;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$;
import org.neo4j.cypher.internal.ConfigMemoryTrackingController;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator$;
import org.neo4j.cypher.internal.runtime.MemoryTrackingController;
import scala.Predef$;
import scala.Serializable;

public final class CypherConfiguration$
implements Serializable {
    public static CypherConfiguration$ MODULE$;

    static {
        new CypherConfiguration$();
    }

    public CypherConfiguration fromConfig(Config config) {
        return new CypherConfiguration((CypherVersion)CypherVersion$.MODULE$.apply(((GraphDatabaseSettings.CypherParserVersion)config.get(GraphDatabaseSettings.cypher_parser_version)).toString()), (CypherPlannerOption)CypherPlannerOption$.MODULE$.apply(((Enum)config.get(GraphDatabaseSettings.cypher_planner)).toString()), (CypherRuntimeOption)CypherRuntimeOption$.MODULE$.apply(((Enum)config.get(GraphDatabaseInternalSettings.cypher_runtime)).toString()), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.query_cache_size)), this.statsDivergenceFromConfig(config), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_hints_error)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold)), Predef$.MODULE$.Long2long((Long)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_exhaustive_shortestpath)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_shortestpath_common_nodes)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.csv_legacy_quote_escaping)), ((Long)config.get(GraphDatabaseSettings.csv_buffer_size)).intValue(), (CypherExpressionEngineOption)CypherExpressionEngineOption$.MODULE$.apply(((Enum)config.get(GraphDatabaseInternalSettings.cypher_expression_engine)).toString()), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_lenient_create_relationship)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_small)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_big)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.enable_pipelined_runtime_trace)), ((Path)config.get(GraphDatabaseInternalSettings.pipelined_scheduler_trace_filename)).toFile(), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_expression_recompilation_limit)), (CypherOperatorEngineOption)CypherOperatorEngineOption$.MODULE$.apply(((Enum)config.get(GraphDatabaseInternalSettings.cypher_operator_engine)).toString()), (CypherInterpretedPipesFallbackOption)CypherInterpretedPipesFallbackOption$.MODULE$.apply(((Enum)config.get(GraphDatabaseInternalSettings.cypher_pipelined_interpreted_pipes_fallback)).toString()), new ConfigMemoryTrackingController(config), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.cypher_enable_runtime_monitors)));
    }

    public StatsDivergenceCalculator statsDivergenceFromConfig(Config config) {
        double divergenceThreshold = (Double)config.get(GraphDatabaseSettings.query_statistics_divergence_threshold);
        double targetThreshold = (Double)config.get(GraphDatabaseInternalSettings.query_statistics_divergence_target);
        long minReplanTime = Predef$.MODULE$.long2Long(((Duration)config.get(GraphDatabaseSettings.cypher_min_replan_interval)).toMillis());
        long targetReplanTime = Predef$.MODULE$.long2Long(((Duration)config.get(GraphDatabaseInternalSettings.cypher_replan_interval_target)).toMillis());
        String divergenceAlgorithm = ((Enum)config.get(GraphDatabaseInternalSettings.cypher_replan_algorithm)).toString();
        return StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(divergenceAlgorithm, divergenceThreshold, targetThreshold, minReplanTime, targetReplanTime);
    }

    public CypherConfiguration apply(CypherVersion version, CypherPlannerOption planner, CypherRuntimeOption runtime, int queryCacheSize, StatsDivergenceCalculator statsDivergenceCalculator, boolean useErrorsOverWarnings, int idpMaxTableSize, long idpIterationDuration, boolean errorIfShortestPathFallbackUsedAtRuntime, boolean errorIfShortestPathHasCommonNodesAtRuntime, boolean legacyCsvQuoteEscaping, int csvBufferSize, CypherExpressionEngineOption expressionEngineOption, boolean lenientCreateRelationship, int pipelinedBatchSizeSmall, int pipelinedBatchSizeBig, boolean doSchedulerTracing, File schedulerTracingFile, int recompilationLimit, CypherOperatorEngineOption operatorEngine, CypherInterpretedPipesFallbackOption interpretedPipesFallback, MemoryTrackingController memoryTrackingController, boolean enableMonitors) {
        return new CypherConfiguration(version, planner, runtime, queryCacheSize, statsDivergenceCalculator, useErrorsOverWarnings, idpMaxTableSize, idpIterationDuration, errorIfShortestPathFallbackUsedAtRuntime, errorIfShortestPathHasCommonNodesAtRuntime, legacyCsvQuoteEscaping, csvBufferSize, expressionEngineOption, lenientCreateRelationship, pipelinedBatchSizeSmall, pipelinedBatchSizeBig, doSchedulerTracing, schedulerTracingFile, recompilationLimit, operatorEngine, interpretedPipesFallback, memoryTrackingController, enableMonitors);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CypherConfiguration$() {
        MODULE$ = this;
    }
}

