/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.result.EagerQuerySubscription;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

class MaterialisedResult
implements QuerySubscriber {
    private final List<AnyValue[]> materialisedRecords = new ArrayList<AnyValue[]>();
    private int numberOfFields;
    private AnyValue[] currentRecord;
    private Throwable error;
    private QueryStatistics statistics = QueryStatistics.EMPTY;
    private QueryExecution queryExecution;

    MaterialisedResult() {
    }

    void consumeAll(QueryExecution queryExecution) throws QueryExecutionKernelException {
        this.queryExecution = queryExecution;
        try {
            queryExecution.consumeAll();
        }
        catch (Exception e) {
            if (e instanceof Status.HasStatus) {
                throw QueryExecutionKernelException.wrapError((Throwable)((Exception)((Status.HasStatus)e)));
            }
            throw QueryExecutionKernelException.wrapError((Throwable)new CypherExecutionException("Query execution failed", (Throwable)e));
        }
    }

    QueryStatistics getQueryStatistics() {
        return this.statistics;
    }

    public void onResult(int numberOfFields) {
        this.numberOfFields = numberOfFields;
    }

    public void onRecord() {
        this.currentRecord = new AnyValue[this.numberOfFields];
    }

    public void onField(int offset, AnyValue value) {
        this.currentRecord[offset] = value;
    }

    public void onRecordCompleted() {
        this.materialisedRecords.add(this.currentRecord);
        this.currentRecord = null;
    }

    public void onError(Throwable throwable) {
        this.error = throwable;
    }

    public void onResultCompleted(QueryStatistics statistics) {
        this.statistics = statistics;
    }

    QueryExecution stream(QuerySubscriber subscriber) {
        return new StreamingExecution(subscriber);
    }

    private class StreamingExecution
    extends EagerQuerySubscription
    implements QueryExecution {
        StreamingExecution(QuerySubscriber subscriber) {
            block2: {
                super(subscriber);
                this.error = MaterialisedResult.this.error;
                try {
                    subscriber.onResult(MaterialisedResult.this.queryExecution.fieldNames().length);
                }
                catch (Exception e) {
                    if (this.error != null) break block2;
                    this.error = e;
                }
            }
        }

        public QueryExecutionType executionType() {
            return MaterialisedResult.this.queryExecution.executionType();
        }

        public ExecutionPlanDescription executionPlanDescription() {
            return MaterialisedResult.this.queryExecution.executionPlanDescription();
        }

        public Iterable<Notification> getNotifications() {
            return MaterialisedResult.this.queryExecution.getNotifications();
        }

        public Iterable<GqlStatusObject> getGqlStatusObjects() {
            return MaterialisedResult.this.queryExecution.getGqlStatusObjects();
        }

        public String[] fieldNames() {
            return MaterialisedResult.this.queryExecution.fieldNames();
        }

        protected QueryStatistics queryStatistics() {
            return MaterialisedResult.this.statistics;
        }

        protected int resultSize() {
            return MaterialisedResult.this.materialisedRecords.size();
        }

        protected void materializeIfNecessary() {
        }

        protected void streamRecordToSubscriber(int servedRecords) throws Exception {
            AnyValue[] recordValues = MaterialisedResult.this.materialisedRecords.get(servedRecords);
            for (int i = 0; i < recordValues.length; ++i) {
                this.subscriber.onField(i, recordValues[i]);
            }
        }
    }
}

