/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.batchinsert;

import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class RelationshipTypeHolder {
    private final ArrayMap<String, Integer> relTypes = new ArrayMap(5, false, false);
    private final ArrayMap<Integer, String> idToName = new ArrayMap(5, false, false);

    RelationshipTypeHolder(RelationshipTypeData[] types) {
        for (RelationshipTypeData type : types) {
            this.relTypes.put(type.getName(), type.getId());
            this.idToName.put(type.getId(), type.getName());
        }
    }

    void addRelationshipType(String name, int id) {
        this.relTypes.put(name, id);
        this.idToName.put(id, name);
    }

    int getTypeId(String name) {
        Integer id = this.relTypes.get(name);
        if (id != null) {
            return id;
        }
        return -1;
    }

    String getName(int id) {
        String name = this.idToName.get(id);
        if (name == null) {
            throw new NotFoundException("No such relationship type[" + id + "]");
        }
        return name;
    }
}

