/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Map;

public class AutoConfigurator {
    private final int totalPhysicalMemMb;
    private final int maxVmUsageMb;
    private final String dbPath;
    private final boolean useMemoryMapped;

    public AutoConfigurator(String dbPath, boolean useMemoryMapped, boolean dump) {
        this.dbPath = dbPath;
        this.useMemoryMapped = useMemoryMapped;
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        long mem = -1L;
        try {
            Class<?> beanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            mem = (Long)method.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        this.totalPhysicalMemMb = mem != -1L ? (int)(mem / 1024L / 1024L) : -1;
        mem = Runtime.getRuntime().maxMemory();
        this.maxVmUsageMb = (int)(mem / 1024L / 1024L);
        if (dump) {
            System.out.println(this.getNiceMemoryInformation());
        }
    }

    public String getNiceMemoryInformation() {
        return "Physical mem: " + this.totalPhysicalMemMb + "MB, Heap size: " + this.maxVmUsageMb + "MB";
    }

    public void configure(Map<Object, Object> config) {
        if (this.totalPhysicalMemMb > 0) {
            if (this.useMemoryMapped) {
                int availableMem = this.totalPhysicalMemMb - this.maxVmUsageMb;
                availableMem -= (int)((float)availableMem * 0.15f);
                this.assignMemory(config, availableMem);
            } else {
                this.assignMemory(config, this.maxVmUsageMb / 2);
            }
        }
    }

    private int calculate(int memLeft, int storeSize, float use, float expand, boolean canExpand) {
        int size = memLeft;
        size = (float)storeSize > (float)memLeft * use ? (int)((float)memLeft * use) : (canExpand ? ((float)storeSize * expand * 5.0f < (float)memLeft * use ? (int)((float)memLeft * use / 5.0f) : (int)((float)memLeft * use)) : storeSize);
        return size;
    }

    private void assignMemory(Map<Object, Object> config, int availableMem) {
        int nodeStore = this.getFileSizeMb("nodestore.db");
        int relStore = this.getFileSizeMb("relationshipstore.db");
        int propStore = this.getFileSizeMb("propertystore.db");
        int stringStore = this.getFileSizeMb("propertystore.db.strings");
        int arrayStore = this.getFileSizeMb("propertyStore.db.arrays");
        int totalSize = nodeStore + relStore + propStore + stringStore + arrayStore;
        boolean expand = false;
        if ((float)totalSize * 1.15f < (float)availableMem) {
            expand = true;
        }
        int memLeft = availableMem;
        relStore = this.calculate(memLeft, relStore, 0.75f, 1.1f, expand);
        nodeStore = this.calculate(memLeft -= relStore, nodeStore, 0.2f, 1.1f, expand);
        propStore = this.calculate(memLeft -= nodeStore, propStore, 0.75f, 1.1f, expand);
        stringStore = this.calculate(memLeft -= propStore, stringStore, 0.75f, 1.1f, expand);
        arrayStore = this.calculate(memLeft -= stringStore, arrayStore, 1.0f, 1.1f, expand);
        memLeft -= arrayStore;
        this.configPut(config, "nodestore.db", nodeStore);
        this.configPut(config, "relationshipstore.db", relStore);
        this.configPut(config, "propertystore.db", propStore);
        this.configPut(config, "propertystore.db.strings", stringStore);
        this.configPut(config, "propertystore.db.arrays", arrayStore);
    }

    private void configPut(Map<Object, Object> config, String store, int size) {
        config.put("neostore." + store + ".mapped_memory", size + "M");
    }

    private int getFileSizeMb(String file) {
        long length = new File(this.dbPath + File.separator + "neostore." + file).length();
        int mb = (int)(length / 1024L / 1024L);
        if (mb > 0) {
            return mb;
        }
        return 1;
    }
}

