/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.impl.core.NodeManager;

public class TransactionEventsSyncHook
implements Synchronization {
    private final Collection<TransactionEventHandler<?>> handlers;
    private final NodeManager nodeManager;
    private List<HandlerAndState> states;
    private TransactionData transactionData;
    private final TransactionManager tm;

    public TransactionEventsSyncHook(NodeManager nodeManager, Collection<TransactionEventHandler<?>> transactionEventHandlers, TransactionManager tm) {
        this.nodeManager = nodeManager;
        this.handlers = transactionEventHandlers;
        this.tm = tm;
    }

    public void beforeCompletion() {
        this.transactionData = this.nodeManager.getTransactionData();
        try {
            if (this.tm.getStatus() != 0) {
                return;
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        this.states = new ArrayList<HandlerAndState>();
        for (TransactionEventHandler<?> handler : this.handlers) {
            try {
                Object state = handler.beforeCommit(this.transactionData);
                this.states.add(new HandlerAndState(handler, state));
            }
            catch (Throwable t) {
                try {
                    this.tm.setRollbackOnly();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw new RuntimeException(t);
            }
        }
    }

    public void afterCompletion(int status) {
        if (status == 3) {
            for (HandlerAndState state : this.states) {
                state.handler.afterCommit(this.transactionData, state.state);
            }
        } else if (status == 4) {
            if (this.states == null) {
                return;
            }
            for (HandlerAndState state : this.states) {
                state.handler.afterRollback(this.transactionData, state.state);
            }
        } else {
            throw new RuntimeException("Unknown status " + status);
        }
    }

    private class HandlerAndState {
        private final TransactionEventHandler handler;
        private final Object state;

        public HandlerAndState(TransactionEventHandler<?> handler, Object state) {
            this.handler = handler;
            this.state = state;
        }
    }
}

