/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.Abstract64BitRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class DynamicRecord
extends Abstract64BitRecord {
    private byte[] data = null;
    private int length;
    private long nextBlock = Record.NO_NEXT_BLOCK.intValue();
    private boolean isLight = true;
    private int type;

    public DynamicRecord(long id) {
        super(id);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    void setIsLight(boolean status) {
        this.isLight = status;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setInUse(boolean inUse) {
        super.setInUse(inUse);
        if (!inUse) {
            this.data = null;
        }
    }

    public void setInUse(boolean inUse, int type) {
        this.type = type;
        this.setInUse(inUse);
    }

    public void setData(byte[] data) {
        this.isLight = false;
        this.length = data.length;
        this.data = data;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DynamicRecord[").append(this.getId()).append(",").append(this.inUse());
        if (this.inUse()) {
            buf.append(",");
            if (this.isLight) {
                buf.append("isLight");
            }
            if (this.data != null) {
                buf.append("byte[" + this.data.length + "]");
            }
        }
        buf.append(",").append(this.nextBlock).append("]");
        return buf.toString();
    }
}

